//: C08:CheckedCast.cpp
// From "Thinking in C++, 2nd Edition, Volume 2"
// by Bruce Eckel & Chuck Allison, (c) 2003 MindView, Inc.
// Available at www.BruceEckel.com.
// Checks casts at runtime
#include <iostream>
#include <vector>
#include "../purge.h"
using namespace std;

class Security {
protected:
  enum {baseID = 0};
public:
  virtual bool isA(int id) {
     return (id == baseID);
  }
};

class Stock : public Security {
  typedef Security Super;
protected:
  enum {OFFSET = 1, typeID = baseID + OFFSET};
public:
  bool isA(int id) {
    return id == typeID || Super::isA(id);
  }
  static Stock* dynacast(Security* s) {
    return (s->isA(typeID)) ?
      static_cast<Stock*>(s) : 0;
  }
};

class Bond : public Security {
  typedef Security Super;
protected:
  enum {OFFSET = 2, typeID = baseID + OFFSET};
public:
  bool isA(int id) {
    return id == typeID || Super::isA(id);
  }
  static Bond* dynacast(Security* s) {
    return (s->isA(typeID)) ?
      static_cast<Bond*>(s) : 0;
  }
};

class Investment : public Security {
  typedef Security Super;
protected:
  enum {OFFSET = 3, typeID = baseID + OFFSET};
public:
  bool isA(int id) {
    return id == typeID || Super::isA(id);
  }
  static Investment* dynacast(Security* s) {
    return (s->isA(typeID)) ?
      static_cast<Investment*>(s) : 0;
  }
  void special() {
    cout << "special Investment function\n";
  }
};

class Metal : public Investment {
  typedef Investment Super;
protected:
  enum {OFFSET = 4, typeID = baseID + OFFSET};
public:
  bool isA(int id) {
    return id == typeID || Super::isA(id);
  }
  static Metal* dynacast(Security* s) {
    return (s->isA(typeID)) ?
      static_cast<Metal*>(s) : 0;
  }
};

int main() {
  vector<Security*> portfolio;
  portfolio.push_back(new Metal);
  portfolio.push_back(new Investment);
  portfolio.push_back(new Bond);
  portfolio.push_back(new Stock);
  for (vector<Security*>::iterator it = 
         portfolio.begin();
       it != portfolio.end(); ++it) {
    Investment* cm = Investment::dynacast(*it);
    if(cm) cm->special();
    else cout << "not a Investment" << endl;
    it++;
  }
  cout << "cast from intermediate pointer:\n";
  Security* sp = new Metal;
  Investment* cp = Investment::dynacast(sp);
  if(cp) cout << "  it's a Investment\n";
  Metal* mp = Metal::dynacast(sp);
  if(mp) cout << "  it's a Metal too!\n";
  purge(portfolio);
} ///:~
