#ifndef __VIGENERE_H
#define __VIGENERE_H

#include <iostream>
#include <fstream>
#include "encryption.h"

using namespace std;

class VigenereEncrypt : public EncryptedFileWriter
{
private:
	string key;
	friend VigenereEncrypt& operator<<(VigenereEncrypt&, const string&);
public:
	VigenereEncrypt(const string& file = "", const string& code = "");
	virtual string encrypt(const string&);	
};

class VigenereDecrypt : public EncryptedFileReader
{
private:
	string key;
	//temp key length is used as we are reading the text word by word
	int key_temp_len;
	friend VigenereDecrypt& operator>>(VigenereDecrypt&, string&);
public:
	VigenereDecrypt(const string& file = "", const string& code = "");
	virtual string decrypt(const string&);
};

VigenereEncrypt& operator<<(VigenereEncrypt&, const string&);
VigenereDecrypt& operator>>(VigenereDecrypt&, string&);

#endif