#include <iostream>
#include <fstream>
#include <string>

#include "vigenere.h"

VigenereEncrypt::VigenereEncrypt(const string& file, const string& code): EncryptedFileWriter(file)
{	
	key = code;
}

VigenereDecrypt::VigenereDecrypt(const string& file, const string& code): EncryptedFileReader(file)
{	
	key = code;
	key_temp_len = 0;
}

/*
  The "encryption" function
  Capitalizes all letters using EncryptedFileWriter
*/
string VigenereEncrypt::encrypt(const string& plain)
{
	size_t t_length = plain.length();
	string strText = plain;

	//encryption
	for (int i = 0, j = 0; i < t_length; ++i) {
		char c = strText[i];
		if (!isalpha(c))
			continue;


		if ((c >= 'A' && c <= 'Z'))
		{
			strText[i] = (c + toupper(key[j]) - 2 * 'A') % 26 + 'A';
			j = (j + 1) % key.length();
		}
		else if (c >= 'a' && c <= 'z') {
			strText[i] = (c + tolower(key[j]) - 2 * 'a') % 26 + 'a';
			j = (j + 1) % key.length();
		}
	}

	const string s = strText;
	return EncryptedFileWriter::encrypt(s);

}

/*
  The "decryption" function
  Converts all letters to lowercase using EncryptedFileReader
*/
string VigenereDecrypt::decrypt(const string& cipher)
{
	size_t t_length = cipher.length();
	string strText = cipher;

	//encryption
	for (int i = 0, j = key_temp_len; i < t_length; ++i) {
		char c = strText[i];
		if (!isalpha(c))
			continue;

		if ((c >= 'A' && c <= 'Z'))
		{
			strText[i] = (c - toupper(key[j]) + 2 * 'A') % 26 + 'A';
			j = (j + 1) % key.length();
			key_temp_len++;
		}
		else if (c >= 'a' && c <= 'z') {
			strText[i] = (c - tolower(key[j]) + 2 * 'a') % 26 + 'a';
			j = (j + 1) % key.length();
			key_temp_len++;
		}

		if (key_temp_len == key.length())
			key_temp_len = 0;

	}

	const string s = strText;
	return EncryptedFileReader::decrypt(s);
}

VigenereEncrypt & operator<<(VigenereEncrypt& ev, const string& str)
{
	if (!ev.is_open())
		cout << ev.encrypt(str);
	else
		static_cast<ofstream&>(ev) << ev.encrypt(str);
	//Invokes default ofstream& print function for ev
	return ev;
}

VigenereDecrypt & operator>>(VigenereDecrypt& vd, string& str)
{
	if (!vd.is_open())
		cin >> str;
	else
		static_cast<ifstream&>(vd) >> str;
	//Invokes default ifstream& read function for vd
	str = vd.decrypt(str);
	return vd;
}

