/*JS*********************************************************************
*
*    Program : TESTBIGSORT
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Test bigsort routines
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id$";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define CONFIG_USELOCALE

#ifdef CONFIG_USELOCALE
# include <locale.h>
#endif

#include <jssubs.h>

/*********     DEFINES                                          *********/
#define OPTSTRING        "hn:m:l:ud"
#define DEFLINELENGTH    80

#define MODE_DOSORT      1
#define MODE_DISTINCT    2

/*********     PROTOTYPES                                       *********/
static long Len = DEFLINELENGTH;

static int doGet(void *uptr,void *buff,long nr)
{
  int l;

  if(fgets(buff,Len,(FILE *)uptr) == NULL) {
    if(!feof((FILE *)uptr))return(-1);
    return(1);
  }
  if((l = strlen(buff) - 1) >= 0) ((char *)buff)[l] = '\0';
  return(0);
}

static int doCompare(void *uptr,const void *a,const void *b)
{
#ifdef CONFIG_USELOCALE
  return(strcoll(a,b));
#else
  return(strcmp(a,b));
#endif
}

int main(int argc,char *argv[])
{
  BigSortHandle bsh;
  FILE *fpIn,*fpOut;
  char *string;
  int c,mode;

#ifdef CONFIG_USELOCALE
  setlocale(LC_ALL,"");
#endif

  BSortTempDir = getenv("TMPDIR");

  mode = MODE_DOSORT;
  while((c = jsGetOpt(&argc,(void *)argv,OPTSTRING,&string)) != EOF)
    switch(c) {
    case 'h':
      goto help;
    case 'n':
      BSortNSeqs  = atoi(string);
      break;
    case 'm':
      BSortMaxMem = atoi(string);
      break;
    case 'l':
      Len = atoi(string);
      break;
    case 'u':
      mode &= ~MODE_DOSORT;
      break;
    case 'd':
      mode |= MODE_DISTINCT;
      break;
    }

  if(argc != 2 && argc != 3) goto help;

  if(strcmp(argv[1],"-") == 0)
    fpIn = stdin;
  else if((fpIn = fopen(argv[1],"r")) == NULL)
    goto error;

  if(argc == 2 || strcmp(argv[2],"-") == 0)
    fpOut = stdout;
  else if((fpOut = fopen(argv[2],"w")) == NULL)
    goto error;

  if(bigSortOpen(&bsh,Len,doGet,(mode & MODE_DOSORT) ? doCompare : NULL,fpIn,\
		 (mode & MODE_DISTINCT) ? BIGSORT_FDISTINCT : 0) == NULL)
    goto error;

#if 1
  if((string = malloc(Len)) == NULL) goto error;
  while(bigSortGet(&bsh,-1,string) >= 0)
    puts(string);
  free(string);
#endif

  bigSortClose(&bsh,1);
  if(fpOut != stdout) fclose(fpOut);
  if(fpIn != stdin) fclose(fpIn);

  return(0);
error:
  jsperror("testbigsort");
  return(30);
help:
  fprintf(stderr,"Usage: testbigsort [<opt>] <input> [<output>]\n\
  Sort lines from the input file to the output file or standard output\n\
  \"-\" reads standard input. The method is multi-phase sorting on temporary\n\
  files which allows the sorting of huge amounts of data that do not fit\n\
  into main memory.\n\
  Available options are:\n\
    -h         Show this help information.\n\
    -l<maxlen> Set the maximum line length. (Default is %ld).\n\
    -n<nseqs>  Set the number of temporary files that are used in sorting\n\
               (Default is %d).\n\
    -u         Do not sort.\n\
    -d         Remove duplicate lines.\n\
    -m<maxmem> Set the maximum used memory for the initial in-memory sorting.\n\
               Defaults to %ld Bytes.\n",Len,BSortNSeqs,BSortMaxMem);
  return(5);
}
