/*JS*********************************************************************
*
*    Program : JSSUBS.H
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Include file for library 'libjssubs.a' and all programs
*		that use this library.
*
*************************************************************************/
#ifndef __JSSUBS_H__ /*   File must not be included more than once!   */
#define __JSSUBS_H__

/*********     GENERAL DEFINES					*********/
#ifndef FALSE
# define FALSE	0
#endif
#ifndef TRUE
# define TRUE	1
#endif

/* ****    Some useful macros (be aware of side effects because   **** */
/* ****     they treat arguments more than once).		  **** */
#ifndef MAX
# define MAX(a,b)  ((a) > (b) ? (a) :  (b))
#endif
#ifndef MIN
# define MIN(a,b)  ((b) > (a) ? (a) :  (b))
#endif
#ifndef ABS
# define ABS(x)    ((x) >= 0  ? (x) : -(x))
#endif

/* ****   I'd like to type PI if I want PI !   ***** */
#ifndef PI
# define PI         3.141592653589793238462643383279
#endif

/* *******  General definitions  *********** */
#define MAXLINE    500 /*  Maximal line length in some routines  */
#define MAXLENGTH  500 /*  Maximal string length in some routines  */

/*  Some systems define FILENAME_MAX very small (14 for example)  */
#ifndef JS_FILENAME_MAX
# if !defined(FILENAME_MAX) || (FILENAME_MAX < 256 && !defined(__MSDOS__))
#  define JS_FILENAME_MAX  256
# else
#  define JS_FILENAME_MAX  FILENAME_MAX
# endif
#endif

/* ******  Common environment variable for options and path ***** */
#define JSENVOPT     "JSOPTIONS"
#define JSENVPATH    "JSPATH"

/* ***********	 Extracted definitions of library code  ********* */

/* ----------- FILE: ErrCodes.c           ------------ */
#define _ERR_BSORTOPEN         1

/* ----------- FILE: bigsort.c            ------------ */
#include <stdio.h>   /*	 For "FILE" definition    */

/*  Structure to access a sorted stream  */
typedef struct {
  /*  0: Memory list ("BSH_Buff"); 1: File access ("BSH_File")  */
  int     BSH_Type;
  long    BSH_Len,BSH_Count,BSH_Curr;
  union {
    FILE  *bsh_File;
    void **bsh_Buff;
  } c;
} BigSortHandle;
#define BSH_File  c.bsh_File
#define BSH_Buff  c.bsh_Buff

/*  For variable mode from bigSortOpen  */
#define BIGSORT_FDISTINCT       (1<<0) /* remove duplicate entries  */

/*  Obtain length of sorted stream  */
#define bigSortLength(bsh)      ((bsh)->BSH_Count)

/*  Seek or rewind a stream and get current position  */
#define bigSortSeek(bsh,pos)    ((bsh)->BSH_Curr = (pos))
#define bigSortRewind(bsh)      bigSortSeek(bsh,0)
#define bigSortCurrPos(bsh)     ((bsh)->BSH_Curr)

/*  Get next set in sequence (sequential access)  */
#define bigSortNext(bsh,buff)   bigSortGet(bsh,-1,buff)

/*  Same as bigSortNext, but do not advance internal pointer  */
#define bigSortPeek(bsh,buff)   bigSortGet(bsh,-2,buff)

/* *******   Prototypes of library functions  ***** */
/*  For C++ compatibility   */
# ifdef __cplusplus
#  define Prototype extern "C"
# else
#  define Prototype extern
# endif

/* ***** File: ErrCodes.c            ***** */
Prototype const char    *JSErrors[];

/* ***** File: bigsort.c             ***** */
Prototype BigSortHandle *bigSortOpen(BigSortHandle *bsh,long len,
				     int (*get)(void *uptr,void *buff,long nr),
				     int (*compare)(void *uptr,
						    const void *a,
						    const void *b),
				     void *uPtr,int mode);
Prototype int            bigSortClose(BigSortHandle *bsh,int mode);
Prototype int            bigSortGet(BigSortHandle *bsh,long nr,void *buff);
Prototype long           bigSortFind(BigSortHandle *bsh,const void *cont,
				     int (*compare)(void *uptr,const void *a,
						    const void *b),void *uPtr,
				     void *dest);
Prototype long           BSortMaxMem;
Prototype int            BSortNSeqs;
Prototype const char    *BSortTempDir;

/* ***** File: jserror.c             ***** */
Prototype int            JSErrNo;

/* ***** File: jsgetopt.c            ***** */
Prototype int		 jsGetOpt(int *pargc,void *argv,const char *optstring,
				  char **poptarg);
Prototype int            jsFirstArg(char *argv[],const char *optstring);
Prototype int		 JSOptMode,JSOptIndex;

/* ***** File: jsperror.c            ***** */
Prototype void           jsperror(const char *s);

/* ***** File: jsstrerr.c            ***** */
Prototype const char    *jsStrError(int err);

# undef Prototype   /* I like to be clean  */

#endif /*  "#ifdef __JSSUBS_H__"  */
