/*JS*********************************************************************
*
*    Program : TRUNCNUMBER
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Truncate a number to decrease precision.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id$";
#endif

/*********     INCLUDES                                         *********/
#include <math.h>
#include <float.h>

/*********     DEFINES                                          *********/

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype double         truncNumber(double x,double tresh,int bDigits);

/*JS*********************************************************************
*   If fabs(x) is below thresh, set it to zero. If bDigits is non-zero,
*    retain only bDigits binary digits in the number x. If bDigits is
*    lower than zero it tells the number of binary digits to remove from
*    the mantissa (double precision).
*************************************************************************/

double truncNumber(double x,double thresh,int bDigits)

/************************************************************************/
{
  double m;
  int sign,e;

  /*  Check treshhold first  */
  if(thresh != 0.0 && fabs(x) < thresh)
    return(0.0);

  /*  Any digits to remove?  */
  if(bDigits == 0) return(x);

  if(bDigits < 0) bDigits += DBL_MANT_DIG;

  if(x < 0.0) {
    sign = -1;
    x = -x;
  } else if(x > 0.0) {
    sign = 1;
  } else
    return(x);

  m = frexp(x,&e);
  x = ldexp(floor(ldexp(m,bDigits) + 0.5),e - bDigits);

  return(sign > 0 ? x : -x);
}

#ifdef TEST
#include <stdio.h>
#include <stdlib.h>

int main(int argc,char *argv[])
{
  int i,bDigits;
  double x,thresh;

  if(argc < 4) {
    printf("Usage: testtruncnum <thresh> <bDigits> <number> ...\n");
    return(5);
  }

  thresh = strtod(argv[1],NULL);
  bDigits = atoi(argv[2]);

  for(i = 3 ; i < argc ; i++) {
    x = strtod(argv[i],NULL);

    printf("%.16g -> %.16g\n",x,truncNumber(x,thresh,bDigits));
  }
  return(0);
}
#endif
