/*JS*********************************************************************
*
*    Program : STRTOL2
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Enhancement to "strtol".
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: strtol2.c,v 1.3 1996/04/18 08:53:40 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype long           strtol2(const char *input,char **endp,int base);
Prototype unsigned long  strtoul2(const char *input,char **endp,int base);

/*JS*********************************************************************
*   Same as strtol, but understands additionally binary values starting
*    with '%'.
*************************************************************************/

long strtol2(const char *input,char **endp,int base)

/************************************************************************/
{
  long value;

  if(base == 0) {
    const char *string;

    /*   Drop spaces     */
    string = input;
    while(isspace(*(unsigned char *)string)) string++;

    /*   Binary value?    */
    if(*string++ == '%') {
      value = strtol(string,endp,2);

      /*  Failure?  */
      if(endp && ((const char *)*endp) == string) *endp = (char *)input;

      return(value);
    }
  }

  return(strtol(input,endp,base));
}

/*JS*********************************************************************
*   Same as strtoul, but understands additionally binary values starting
*    with '%'.
*************************************************************************/

unsigned long strtoul2(const char *input,char **endp,int base)

/************************************************************************/
{
  unsigned long value;

  if(base == 0) {
    const char *string;

    /*   Drop spaces     */
    string = input;
    while(isspace(*(unsigned char *)string)) string++;

    /*   Binary value?    */
    if(*string++ == '%') {
      value = strtoul(string,endp,2);

      /*  Failure?  */
      if(endp && ((const char *)*endp) == string) *endp = (char *)input;

      return(value);
    }
  }

  return(strtoul(input,endp,base));
}
