/*JS*********************************************************************
*
*    Program : STRTOID
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Similar to "strtol", but reads an C like identifier.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: strtoid.c,v 1.1 1996/07/31 19:03:02 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <ctype.h>

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype long           strtoid(const char *input);

/*JS*********************************************************************
*   Returns the length of the C like identifier in input.
*************************************************************************/

long strtoid(const char *input)

/************************************************************************/
{
  const char *string;

  string = input;
  while(isalpha(*(unsigned char *)string) || *string == '_') {
    string++;

    while(isdigit(*(unsigned char *)string)) string++;
  }

  return(string - input);
}
