/*JS*********************************************************************
*
*    Program : STRICOMPARE
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Useful string compare routine: case insensitive.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: stricomp.c,v 1.2 1996/10/23 16:10:03 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*********     DEFINES                                          *********/

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype const char    *stricompare(const char *input,const char *string);
Prototype int            striacmp(const char *s1,const char *as);

/*JS*********************************************************************
*   Compares 'string' with beginning of 'input' ignoring upper/lower case.
*    Upper case characters in 'string' mark a valid abbreviation (up to
*    the character before the upper case one) of the word. On failure
*    returns NULL, otherwise first position after 'string' in the input.
*************************************************************************/

const char *stricompare(const char *input,const char *string)

/************************************************************************/
{
  while(*string) {
    if(tolower(*(unsigned char *)string) != tolower(*(unsigned char *)input)) {
      return(isupper(*(unsigned char *)string) ? input : NULL);
    }
    input++;
    string++;
  }

  return(input);
}

/*JS*********************************************************************
*   Compares 's1' with 'as' similar to "strcmp", but ignores upper/lower
*    case. Upper case characters in 'as' mark a valid abbreviation (up to
*    the character before the upper case one) of the word. On success
*    returns 0, otherwise the difference of the failed character.
*************************************************************************/

int striacmp(const char *s1,const char *as)

/************************************************************************/
{
  while(*as && *s1) {
    if(tolower(*(unsigned char *)s1) != tolower(*(unsigned char *)as))
      return(*s1 - *as);

    s1++;
    as++;
  }

  return(isupper(*(unsigned char *)as) ? 0 : (*s1 - *as));
}
