/*JS*********************************************************************
*
*    Program : SCALPROD
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Scalar product of complex vectors.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: scalprod.c,v 1.1 94/09/26 10:32:59 joerg Stab Locker: joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <math.h>

#include <jscmplx.h>

/*********     DEFINES                                          *********/
/*  START-DEFINITIONS */
#include "jscmplx.h" /*  For "dcmplx" definition  */
/*  END-DEFINITIONS */

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype dcmplx         scalprod(const dcmplx *a,const dcmplx *b,int n);

/*JS*********************************************************************
*   Calculates the complex scalar <a|b> , where a is complex conjugated.
*************************************************************************/

dcmplx scalprod(const dcmplx *a,const dcmplx *b,int n)

/************************************************************************/
{
  int i;
  dcmplx result;

  SETC(result,0.0,0.0);

  for(i = 0 ; i < n ; i++)
    ADDCOCCO(result,b[i],a[i]);

  return(result);
}
