/*JS*********************************************************************
*
*    Program : PLOT
*    Language: ANSI-C with TW Graph
*    Author  : Joerg Schoen
*    Purpose : Plots data
*
*    Part    : Header file
*
*              $Id: plot.h,v 4.0 1994/11/25 10:36:41 joerg Stab joerg $
*
*************************************************************************/

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include <jsconfig.h>

#include <jssubs.h>

#include <fplot.h>

#ifdef CONFIG_NO_STRDUP
# define strdup  mystrdup  /*  strdup is not POSIX conformant  */
#endif

#ifdef DEBUG_ALLOC
 /*  Debug memory allocation regarding leakage	*/
# include <dbgalloc.h>
#endif

/*********     DEFINES                                          *********/
#define VERSION "4.3 "__DATE__

#define PSEXT       ".ps"
#define INPUTEXT    ".out" /*  is tried if file not found      */

/*  Flags for FP_User field  */
#define USER_RESCALED     (1<<0)

/*  Who many commands can be stored   */
#define MAXCOMMAND 100

typedef enum plotMode {
  PLAIN, XYCURVE, SPECTRUM, SURFACE, CONTOUR, SURFCONTOUR
} PlotMode;

typedef enum plotType {
  D2,D3
} PlotType;

/*  Structure to express a boundary value: not set,
 *   set, upper or lower limit, factor to original
 *   value
 */
typedef struct {
  enum {
    BV_NSET, BV_EQUAL, BV_LLIM, BV_ULIM, BV_FACTOR
  } BV_Attr;
  double BV_Value;
} BoundValue;

typedef struct {
  enum {
    BP_INTERVALL,BP_POINT
  } BP_Type;
  BoundValue BP_Min,BP_Max;
} BoundPair;

/*  General structure to define output device dependent functions  */
typedef struct outputDevice {
  const char *name;

  /*  General mode (see definitions below)  */
  long mode;
  ProgOpt *devOpts;
  const char **optHelp;

  char *fileName;

  /* ***  User callable functions  *** */
  int   (*Init)(char *name);
  char *(*DeInit)(void);

  int   (*Area)(PlotType type,double xMin,double xMax,
		double yMin,double yMax,double zMin,double zMax);
  int   (*Next)(int what);

  int   (*Draw2D)(PlotMode mode,void *xValues,void *yValues,int nx);
  int   (*Draw3D)(PlotMode mode,void *xValues,void *yValues,void *data,
		  int nx,int ldx,int ny);

  int   (*DrawLegend)(PlotType type,PlotMode mode,char *title,
		      char *xAxis,char *yAxis,char *zAxis);

/* private: */
  double picLen,picWidth;
} OutputDevice;

/* ***  Definitions for variable mode  *** */
#define OUTPUTDEV_DOUBLE       (1<<1) /*  double precision library  */

/*  For routine Next  */
#define OUTPUTDEV_NEXTNEWPAGE    1
#define OUTPUTDEV_NEXTVERBOSE    2
#define OUTPUTDEV_NEXTNOINC      4

/* ****  General macro to use device  *** */
#define DEVICE   OutDev[CurrentDevice]

#ifndef Prototype
# define Prototype extern
#endif


/* ***** File: plot.c                ***** */
Prototype FPFile	*fplotOpenExt(char *fileName,int mode);
Prototype int		 Verbose,RemainingFiles,CurrentPicture;
Prototype BoundPair     *Scales;
Prototype int            NScales;
Prototype FPFile	*PlotFile,*PlotOutFile;
Prototype int            PlotOutState;

/* ***** File: plot2.c               ***** */
Prototype int            plotPicture(FPPicture *picture,PlotMode mode,int part,
				     const BoundPair *bounds,int nBounds,
				     const BoundPair *scales,int nScales);
Prototype void		 showpicture(FPPicture *picture);
Prototype int		 writePicture(FPPicture *picture,int mode,int part,
				      const BoundPair *bounds,int nBounds,
				      const BoundPair *scales,int nScales,
				      FPFile *fpOut);

/* ***** File: plotdev.c             ***** */
Prototype OutputDevice  *OutDev[];
Prototype int            NOutputDevices,CurrentDevice;

/* ***** File: plotparse.y           ***** */
Prototype int		 parse(char *commandString,int mode);
