/*JS*********************************************************************
*
*    Program : PERMUTE
*    Language: ANSI - C
*    Author  : Joerg Schoen
*    Purpose : Auxiliary routines for main routine reduce:
*               Permute any array of objects
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: permute.c,v 1.3 1995/09/14 08:36:33 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdlib.h>
#include <string.h>

#include <jssubs.h>

/*********     DEFINES                                          *********/

#ifndef RED_INDSTART
# define RED_INDSTART 0
#endif

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype int            permute(void *vector,int n,int *permutation,
				 int size,void *work);

/*JS*********************************************************************
*   Permute the n objects of size "size" in the vector with the
*    permutation using the workspace work (Must have at least the size
*    "size"!). The permutation is one returned by the routine reduce.
*************************************************************************/

int permute(void *vector,int n,int *permutation,int size,void *work)

/************************************************************************/
{
  register int count,start,current,next,newstart;
  register char *a = (char *)vector;
  register void *work2 = NULL;

  /*  Check if user allocated memory  */
  if(work == NULL && (work = work2 = malloc(size)) == NULL) return(-1);

  newstart = 0;

  for(count = n ; count > 0 ; ) {
    /*  Seek non zero element in permutation  */
    for(start = newstart ; start < n ; start++)
      if(permutation[start] >= 0) break;

    /*  Up to this point no positive elements were found   */
    newstart = start + 1;

    /*   Get following element    */
    next = permutation[current = start] - RED_INDSTART;

    /*   Mark element with negating    */
    permutation[current] = -1 - next;
    count--; /*  Count  */

    /*   Check sequences of one element   */
    if(next == start) continue;

    /*   Copy first element to workspace  */
    memcpy(work,a + start * size,size);

    do {
      /*  Copy next element to current   */
      memcpy(a + current * size,a + next * size,size);

      /*  Go to next element   */
      current = next;
      next = permutation[current] - RED_INDSTART;

      /*   Mark element with negating    */
      permutation[current] = -1 - next;

      count--;
    } while(next != start);

    /*   Finally copy workspace to last element   */
    memcpy(a + current * size,work,size);
  }

  /*   Now restore contents of permutation vector for reuse   */
  for(count = 0 ; count < n ; count++)
    permutation[count] = RED_INDSTART - 1 - permutation[count];

  if(work2) free(work2);
  return(0);
}
