/*JS*********************************************************************
*
*    Program : MKTIME2
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Similar to ANSI "mktime", but takes all needed parameters
*              as single arguments.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: mktime2.c,v 1.1 1996/05/14 13:39:08 joerg Stab joerg $";
#endif

/*********     DEFINES                                          *********/
/*  START-DEFINITIONS */
#include <time.h>    /*  For "time_t" definition  */
/*  END-DEFINITIONS */

/*#define CALC_WDAY*/

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <time.h>

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype time_t         mktime2(int year,int month,int day,
				 int hour,int minute,int second);

/*JS*********************************************************************
*   Makes up a time_t date stamp.
*************************************************************************/

time_t mktime2(int year,int month,int day,int hour,int minute,int second)

/************************************************************************/
{
  struct tm tim,tim2,*t;
  time_t retvalue;
#ifdef CALC_WDAY
static int MonthOffset[] = {
  /* JAN  FEB  MAR  APR  MAY  JUN  JUL	AUG  SEP  OKT  NOV  DEZ  */
       0,  31,	59,  90, 120, 151, 181, 212, 243, 273, 304, 334
};
#endif

  if((retvalue = time(NULL)) == -1 || (t = localtime(&retvalue)) == NULL)
    return(-1);

  /*   Set up structure correctly    */
  tim = *t; /*  default  */
  if(second != -1) tim.tm_sec  = second;
  if(minute != -1) tim.tm_min  = minute;

  if(hour != -1)   tim.tm_hour = hour;
  else hour = tim.tm_hour; /*  is needed later  */

  if(day != -1)    tim.tm_mday = day;
  else day = tim.tm_mday; /*  is needed later  */

  if(month != -1)  tim.tm_mon  = month - 1;
  else month = 1 + tim.tm_mon; /*  is needed later  */

  /*  Get real year if only lowest two digits were given  */
  if(year == -1)
    year = 1900 + tim.tm_year; /*  is needed later  */
  else {
    if(year < 100) {
      int century = (1900 + t->tm_year) / 100;
      year += century * 100;
    }
    tim.tm_year = year - 1900;
  }

#ifdef CALC_WDAY
  /*  Get current day in year	*/
  tim.tm_yday = MonthOffset[month - 1] + day;

  /*  Correct them for week day   */
  if(month < 3) {
    month += 12;
    year--;
  }

  /*  Get current day in week	*/
  tim.tm_wday = (day + 30 * month + (3 * month + 3) / 5 +
		 365 * year + year / 4 - year / 100 + year / 400 + 1) % 7;
#endif

  /*  First try with no summer time  */
  tim.tm_isdst = 0;

  /*  Make backup of structure	 */
  tim2 = tim;

  retvalue = mktime(&tim);

  if(localtime(&retvalue)->tm_hour != hour) {
    /*	Ok, try with summer time  */
    tim = tim2;
    tim.tm_isdst = 1;
    retvalue = mktime(&tim);

    if(localtime(&retvalue)->tm_hour != hour) return(-1);
  }

  return(retvalue);
}
