/*JS*********************************************************************
*
*    Program : LOGPRINTF
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Simple print for producing a log file.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: logprintf.c,v 1.4 1995/12/07 12:43:09 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <jssubs.h>

/*********     DEFINES						*********/
/*  START-DEFINITIONS */
#include <stdio.h>   /*	 For "FILE" definition    */
/*  END-DEFINITIONS */

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype int            logprintf(const char *format, ...);
Prototype int            logprintff(const char *format, ...);
Prototype FILE          *LogFile;
Prototype int            BatchMode;

/*********     GLOBAL VARIABLES                                 *********/
FILE *LogFile   = NULL;
int   BatchMode = 0;

/*JS*********************************************************************
*   If all printf's in the program are redirected to logprintf via
*     #define printf logprintf
*    the output is printed to stdout and to the file LogFile. If
*    BatchMode is true, output to stdout is inhibited. Also, if LogFile
*    is NULL, no output is written to LogFile.
*************************************************************************/

int logprintf(const char *format, ...)

/************************************************************************/
{
  va_list ap;
  int len = 0; /*   Default value if nothing is printed     */

  /*   Initialize argument list    */
  va_start(ap,format);

  /*   Now print to stdout if not in Batch Mode...   */
  if(!BatchMode) len = vprintf(format,ap);

  /*   ...and to log file if present    */
  if(LogFile) len = vfprintf(LogFile,format,ap);

  /*    Deinitialize argument list   */
  va_end(ap);

  return(len);
}

/*JS*********************************************************************
*   Same as logprintf, but buffers are flushed after the output.
*************************************************************************/

int logprintff(const char *format, ...)

/************************************************************************/
{
  va_list ap;
  int len = 0; /*   Default value if nothing is printed     */

  /*   Initialize argument list    */
  va_start(ap,format);

  /*   Now print to stdout if not in Batch Mode...   */
  if(!BatchMode) {
    len = vprintf(format,ap);
    fflush(stdout); /* I want to look immediately at results!  */
  }

  /*   ...and to log file if present    */
  if(LogFile) {
    len = vfprintf(LogFile,format,ap);
    fflush(LogFile); /* I want to look immediately at results!  */
  }

  /*    Deinitialize argument list   */
  va_end(ap);

  return(len);
}
