
/* MACHINE GENERATED */
/*JS*********************************************************************
*
*    Program : JTSUBS
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Auxiliary routines for the Jahn-Teller programs
*
*    Part    : Header file
*
*              $Id: jtsubs.h,v 1.1 94/03/30 14:43:45 joerg Exp Locker: joerg $
*
*************************************************************************/

#ifndef __JTSUBS_H__
#define __JTSUBS_H__

/*********     INCLUDES 					*********/
#include <jssubs.h>

/*********     DEFINES						*********/
#define ELECFUNC_NUM	3
#define ELECFUNC_OFFSET 1

/* ********************************************************** */
/* ****  Structure to store the quantum numbers |n,l,e>  **** */
/* ********************************************************** */
typedef struct QNumber {
  short QN_N,QN_L,QN_Elec;
} QNumber;

/* ******************************************************** */
/* ***********	 Defines for the dump files    ************ */
/* ******************************************************** */
/* ***	Program jate:	*** */
/*  Magic value for dump file where eigenvalues and -vectors stored.  */
#define JATEDUMPMAGIC  (('J'<<24) | ('T'<<16) | ('M'<<8) | '2')

#define JATEDUMP_UNUSED  6

/*  Structure for the dump  */
typedef struct JateDumpHeader {
  long DH_Magic;
  /*	   The parameters:	  */
  int DH_Mode;
  int DH_NMax,DH_VMax,DH_Dim,DH_NSave,DH_JTildp3h,DH_Dummy;
  double DH_Omega,DH_OmegaQuant,DH_E_E,DH_E_A,DH_K,DH_G,DH_L,DH_F;
  double DH_DeltaDiag;
  double DH_Unused[JATEDUMP_UNUSED];
} JateDumpHeader;

/*   To store the contents of one dump file (routine JTReadDump)  */
typedef struct JateDumpFile {
  struct JateDumpHeader JDF_Header;
  int			JDF_NStart;
  QNumber	       *JDF_QNum;
  double	       *JDF_EigenValue;
  double	       *JDF_EigenVector;
} JateDumpFile;

#define JDF_Magic       JDF_Header.DH_Magic
#define JDF_Mode        JDF_Header.DH_Mode
#define JDF_NMax        JDF_Header.DH_NMax
#define JDF_VMax        JDF_Header.DH_VMax
#define JDF_Dim	        JDF_Header.DH_Dim
#define JDF_NSave       JDF_Header.DH_NSave
#define JDF_JTildp3h    JDF_Header.DH_JTildp3h
#define JDF_Omega       JDF_Header.DH_Omega
#define JDF_OmegaQuant  JDF_Header.DH_OmegaQuant
#define JDF_E_E	        JDF_Header.DH_E_E
#define JDF_E_A	        JDF_Header.DH_E_A
#define JDF_K	        JDF_Header.DH_K
#define JDF_G	        JDF_Header.DH_G
#define JDF_L	        JDF_Header.DH_L
#define JDF_F	        JDF_Header.DH_F
#define JDF_DeltaDiag   JDF_Header.DH_DeltaDiag

/*     Defines for routine JTReadDump   */
#define JTRD_PRHEADER   (1<<0)
#define JTRD_PRQNUM	(1<<1)
#define JTRD_PREVAL	(1<<2)
#define JTRD_PREVEC	(1<<3)
#define JTRD_USEPATH    (1<<4) /*  Use jsfopen instead of fopen  */
#define JTRD_PRNAME	(1<<5)

/* ***	 Program spec:	 *** */
#define SPECDUMPMAGIC  (('S'<<24) | ('P'<<16) | ('C'<<8) | '1')

/*  Structure for the dump  */
typedef struct SpecDumpHeader {
  long DH_Magic;
  long DH_Length;
  int  DH_NMax,DH_NrStates;
} SpecDumpHeader;

/*   To store the contents of a spec dump file	*/
typedef struct SpecDumpFile {
  SpecDumpHeader SDF_Header;
  int		 SDF_Dim;
  dcmplx	*SDF_Vector;
} SpecDumpFile;

#define SDF_Magic     SDF_Header.DH_Magic
#define SDF_Length    SDF_Header.DH_Length
#define SDF_NMax      SDF_Header.DH_NMax
#define SDF_NrStates  SDF_Header.DH_NrStates

#ifndef Prototype
#define Prototype extern
#endif

/* ***** File: jtsubs.c              ***** */
Prototype char		   *PlotLabel[],*PlotAxeLabel[];
Prototype JateDumpFile	   *JTReadDump(char *name,int mode,int nStart,
				       int nEnd);
Prototype void		    JTFreeDump(JateDumpFile *dumpFile);
Prototype SpecDumpFile	   *SPReadDump(char *name);
Prototype void		    SPFreeDump(SpecDumpFile *specDump);
Prototype const char	    ElecChar[],*JTildText[2][3];

#endif
