/*JS*********************************************************************
*
*    Program : JSSUBS.H
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Include file for library 'libjssubs.a' and all programs
*		that use this library.
*
*************************************************************************/
#ifndef __JSSUBS_H__ /*   File must not be included more than once!   */
#define __JSSUBS_H__

/*********     GENERAL DEFINES					*********/
#ifndef FALSE
# define FALSE	0
#endif
#ifndef TRUE
# define TRUE	1
#endif

/* ****    Some useful macros (be aware of side effects because   **** */
/* ****     they treat arguments more than once).		  **** */
#ifndef MAX
# define MAX(a,b)  ((a) > (b) ? (a) :  (b))
#endif
#ifndef MIN
# define MIN(a,b)  ((b) > (a) ? (a) :  (b))
#endif
#ifndef ABS
# define ABS(x)    ((x) >= 0  ? (x) : -(x))
#endif

/* ****   I'd like to type PI if I want PI !   ***** */
#ifndef PI
# define PI         3.141592653589793238462643383279
#endif

/* *******  General definitions  *********** */
#define MAXLINE    500 /*  Maximal line length in some routines  */
#define MAXLENGTH  500 /*  Maximal string length in some routines  */

/*  Some systems define FILENAME_MAX very small (14 for example)  */
#ifndef JS_FILENAME_MAX
# if !defined(FILENAME_MAX) || (FILENAME_MAX < 256 && !defined(__MSDOS__))
#  define JS_FILENAME_MAX  256
# else
#  define JS_FILENAME_MAX  FILENAME_MAX
# endif
#endif

/* ******  Common environment variable for options and path ***** */
#define JSENVOPT     "JSOPTIONS"
#define JSENVPATH    "JSPATH"

/* ***********	 Extracted definitions of library code  ********* */

/* ----------- FILE: ErrCodes.c           ------------ */
#define _ERR_FPLTCOPY          1
#define _ERR_FPLTREAD          3
#define _ERR_FPLTOPEN          9
#define _ERR_FPLTTRANS        10
#define _ERR_COMPEXPR         11
#define _ERR_POLINT           20
#define _ERR_SPLINE           21
#define _ERR_PPROGOPTS        22
#define _ERR_CFFT             25
#define _ERR_CFFTN            26

/* ----------- FILE: cfft.c               ------------ */
#include "jscmplx.h" /*  For "dcmplx" definition  */

/* ----------- FILE: compexpr.c           ------------ */
typedef struct {
  char          *EX_Name;  /*  When this expression is a function, the name */
  int            EX_NVars; /*  Number of variables  */
  int            EX_MaxStack; /*  Maximal stack depth needed  */
  double        *EX_Consts;   /*  Table of contant values  */
  unsigned long *EX_IpnCode; /* Code table for interpreting this expression */
} Expression;
#define _typedef_Expression

/* ----------- FILE: flocks.c             ------------ */
#include <stdio.h>   /*	 For "FILE" definition    */

/*  Definitions for routine lockRegion and fopenLock  */
/*  Don't change these values!  */
#define LOCK_READ     0
#define LOCK_READW    1
#define LOCK_WRITE    2
#define LOCK_WRITEW   3
#define LOCK_UNLOCK   4

/*  Macros for usage of routine lockRegion2  */
#define lockRegion(fp,type,offset,whence,len)  \
	lockRegion2(fileno(fp),type,offset,whence,len)

#define lockRead(fp,off,whence,len)   lockRegion(fp,LOCK_READ,off,whence,len)
#define lockReadW(fp,off,whence,len)  lockRegion(fp,LOCK_READW,off,whence,len)

#define lockWrite(fp,off,whence,len)  lockRegion(fp,LOCK_WRITE,off,whence,len)
#define lockWriteW(fp,off,whence,len) lockRegion(fp,LOCK_WRITEW,off,whence,len)

#define unLock(fp,off,whence,len)     lockRegion(fp,LOCK_UNLOCK,off,whence,len)

/* ----------- FILE: jsgetline.c          ------------ */

/*  For parameter 'mode' of jsgetline  */
#define GETLINE_RMEOL     (1<<0)  /*  Remove '\n'  */
#define GETLINE_CONCAT    (1<<1)  /*  Allow line concatenation  */
#define GETLINE_RMCONCAT  (1<<2)  /*  Remove "\\\n" sequences  */
#define GETLINE_COMMENT   (1<<3)  /*  Allow shell like comments (" .. # ..") */
#define GETLINE_UNIQUE    (1<<4)  /*  Make returned line unique  */

/* ----------- FILE: mktime2.c            ------------ */
#include <time.h>    /*  For "time_t" definition  */

/* ----------- FILE: progopts.c           ------------ */

/*  For PO_Flags field  */
#define PROPT_TYPE_MASK  (15<<24)

/*  Flags set by the routine  */
#define PROPT_FLAG_ISSET  (1<<28)
#define PROPT_FLAG_HIDE   (1<<29)

/*  Currently implemented types  */
#define PROPT_IVALUE      (1<<24)
#define PROPT_DVALUE      (2<<24)
#define PROPT_STRING      (3<<24)
#define PROPT_BOOL        (4<<24)
#define PROPT_ISET        (5<<24)
#define PROPT_SUBOPT     (10<<24)
#define PROPT_ABBREV     (11<<24)

#define PROPT_LENGTH     ((1<<24)-1)

typedef struct {
  const char   *PO_Name;
  unsigned long PO_Flags;
  void         *PO_Ptr;
} ProgOpt;

/* ----------- FILE: vaprintf.c           ------------ */
#include <stdarg.h>  /*  For "va_list" definition */

/* *******   Prototypes of library functions  ***** */
/*  For C++ compatibility   */
# ifdef __cplusplus
#  define Prototype extern "C"
# else
#  define Prototype extern
# endif

/* ***** File: ErrCodes.c            ***** */
Prototype const char    *JSErrors[];

/* ***** File: calcderiv.c           ***** */
Prototype int            calcDeriv(double *data,int n,double x0,double x1);
Prototype int            calcDerivFFT(double *data,int n,double x0,double x1);

/* ***** File: cfft.c                ***** */
Prototype int            cfft(dcmplx data[],unsigned long n,int isign);

/* ***** File: cfftn.c               ***** */
Prototype int            cfftn(dcmplx data[],long nn[],long lDim,int nDim,
			       int isign);
Prototype int            cfftnInit(long nn[],int nDim);

/* ***** File: compexpr.c            ***** */
Prototype Expression    *CompDefinition(const char *input,
					const Expression *fcts[],
					const char **pEnd);
Prototype Expression    *CompExpression(const char *input,const char *vars[],
                                        const Expression *fcts[],
					const char **pEnd);
Prototype void           ShowExpression(const Expression *expr,
					const char *vars[],
                                        const Expression *fcts[]);
Prototype double         EvalExpression(const Expression *expr,
					const double vars[],double *stack,
					const Expression *fcts[]);
Prototype int            ExpressionMode;

/* ***** File: critical.c            ***** */
Prototype void           criticalStart(void);
Prototype void           criticalEnd(void);

/* ***** File: cstrcompile.c         ***** */
Prototype long           cStrCompile(const char *src,char *dest);

/* ***** File: errfkt.c              ***** */
Prototype double         errfkt(double x);

/* ***** File: evalstring.c          ***** */
Prototype double         EvalString(const char *string,const char *varsNames[],
				    const double vars[],
				    const Expression *fcts[],
				    const char **pEnd);

/* ***** File: flocks.c              ***** */
Prototype int            lockRegion2(int fd,int type,long offset,int whence,
				     long len);
Prototype FILE          *fopenLock(const char *name,const char *mode,int type);

/* ***** File: fopenpath.c           ***** */
Prototype FILE		*fopenPath(const char *name,const char *mode);
Prototype const char	*FOpenPath;
Prototype FILE		*fopenScan(const char *name,const char *mode);
Prototype const char	*FOpenName;

/* ***** File: freeexpr.c            ***** */
Prototype void           FreeExpression(Expression *expr);

/* ***** File: intpow.c              ***** */
Prototype double         intpow(double x,int n);

/* ***** File: jserror.c             ***** */
Prototype int            JSErrNo;

/* ***** File: jsgetline.c           ***** */
Prototype char          *jsgetline(FILE *fp,int mode);

/* ***** File: jsgetopt.c            ***** */
Prototype int		 jsGetOpt(int *pargc,void *argv,const char *optstring,
				  char **poptarg);
Prototype int            jsFirstArg(char *argv[],const char *optstring);
Prototype int		 JSOptMode,JSOptIndex;

/* ***** File: jsperror.c            ***** */
Prototype void           jsperror(const char *s);

/* ***** File: jsstrerr.c            ***** */
Prototype const char    *jsStrError(int err);

/* ***** File: lcfftn.c              ***** */
Prototype int            lcfftn(dcmplx data[],long nn[],int lDim,int nDim,
				int isign);
Prototype int            setLibFFTn(char *name);
Prototype char          *showLibFFTn(int mode);

/* ***** File: logprintf.c           ***** */
Prototype int            logprintf(const char *format, ...);
Prototype int            logprintff(const char *format, ...);
Prototype FILE          *LogFile;
Prototype int            BatchMode;

/* ***** File: mktime2.c             ***** */
Prototype time_t         mktime2(int year,int month,int day,
				 int hour,int minute,int second);

/* ***** File: permute.c             ***** */
Prototype int            permute(void *vector,int n,int *permutation,
				 int size,void *work);

/* ***** File: polint.c              ***** */
Prototype double         polInterpol(double x,const double xa[],
				     const double ya[],int n,double *pDy);
Prototype double        *polIntData(const double *x,const double *y,
				    int n,int nNew,double *yNew);

/* ***** File: progopts.c            ***** */
Prototype int            parseProgOpts(const char *input,ProgOpt opts[]);
Prototype void           showProgOpts(FILE *fp,const ProgOpt opts[],
				      const char *help[],const char *delimit);

/* ***** File: rfft.c                ***** */
Prototype int            rfft(double data[],unsigned long n,int isign);

/* ***** File: ridderiv.c            ***** */
Prototype double         ridDeriv(double x,double h,double (*func)(double),
				  double *pErr);

/* ***** File: scalprod.c            ***** */
Prototype dcmplx         scalprod(const dcmplx *a,const dcmplx *b,int n);

/* ***** File: spline.c              ***** */
Prototype double        *spline(const double xa[],const double ya[],int n,
				double yp1,double ypn,double *y2);
Prototype double         splint(double x,const double xa[],const double ya[],
				const double y2[],int n,int lower);
Prototype double        *spline2d(const double x1a[],const double x2a[],
				  const double ya[],int n1,int n2,double *y2);
Prototype double         splint2d(double x1,double x2,const double x1a[],
				  const double x2a[],const double ya[],
				  int n1,int n2,double *y2);
Prototype double        *splineData(const double *x,const double *y,
				    int n,int nNew,double *yNew);

/* ***** File: strcomp.c             ***** */
Prototype const char    *strcompare(const char *input,const char *string);

/* ***** File: stricomp.c            ***** */
Prototype const char    *stricompare(const char *input,const char *string);
Prototype int            striacmp(const char *s1,const char *as);

/* ***** File: strtoid.c             ***** */
Prototype long           strtoid(const char *input);

/* ***** File: strtol2.c             ***** */
Prototype long           strtol2(const char *input,char **endp,int base);
Prototype unsigned long  strtoul2(const char *input,char **endp,int base);

/* ***** File: truncnum.c            ***** */
Prototype double         truncNumber(double x,double tresh,int bDigits);

/* ***** File: vaprintf.c            ***** */
Prototype char          *aprintf(const char *format, ...);
Prototype char          *vaprintf(const char *format,va_list ap);
Prototype long           vlprintf(const char *format,va_list ap);

# undef Prototype   /* I like to be clean  */

#endif /*  "#ifdef __JSSUBS_H__"  */
