/*JS*********************************************************************
*
*    Program : JSGETLINE
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Get a line of arbitrary length with some additional
*              options.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: jsgetline.c,v 1.2 1996/04/18 08:51:36 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>

/*********     DEFINES                                          *********/
#define COMMENT_INTRODUCER  '#'  /*  Comments start with this character */

/*  START-DEFINITIONS  */
#include <stdio.h>   /*	 For "FILE" definition    */

/*  For parameter 'mode' of jsgetline  */
#define GETLINE_RMEOL     (1<<0)  /*  Remove '\n'  */
#define GETLINE_CONCAT    (1<<1)  /*  Allow line concatenation  */
#define GETLINE_RMCONCAT  (1<<2)  /*  Remove "\\\n" sequences  */
#define GETLINE_COMMENT   (1<<3)  /*  Allow shell like comments (" .. # ..") */
#define GETLINE_UNIQUE    (1<<4)  /*  Make returned line unique  */
/*  END-DEFINITIONS  */

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype char          *jsgetline(FILE *fp,int mode);

/*JS*********************************************************************
*   Read a line of arbitrary length into a static buffer.
*************************************************************************/

char *jsgetline(FILE *fp,int mode)

/************************************************************************/
{
  long i,c,state;
static char *Buffer;
static long   BuffLen;

  for(state = 0, i = 0 ; state >= 0 && (c = getc(fp)) != EOF ; ) {
    if(i >= BuffLen) {
      BuffLen += 100;
      if((Buffer = (char *)realloc(Buffer,BuffLen)) == NULL) {
	BuffLen = 0;
	return(NULL);
      }
    }

    switch(state) {
    case 0:
      if(c == '\n') {
	state = -1;
	if(mode & GETLINE_RMEOL) continue;
      } else if(c == '\\' && (mode & GETLINE_CONCAT))
	state = 1;
      else if(c == COMMENT_INTRODUCER && (mode & GETLINE_COMMENT)) {
	state = 2;
	continue;
      }
      break;
    case 1: /* **  Ignore special meaning  ** */
      state = 0;
      if(c == '\n' && (mode & (GETLINE_RMCONCAT|GETLINE_RMEOL))) {
	i--;
	continue;
      }
      break;
    case 2: /* **  Scan comment 'til EOL  ** */
      if(c == '\n') {
	state = -1;
	if(!(mode & GETLINE_RMEOL)) break;
      }
      continue; /*  don't save  */
    }

    Buffer[i++] = c;
  }

  if(c == EOF && i == 0) return(NULL);

  Buffer[i] = '\0';

  if(mode & GETLINE_UNIQUE) {
    char *save = Buffer;

    Buffer = NULL;
    BuffLen = 0;
    return(save);
  }

  return(Buffer);
}

#ifdef TEST
int main(int argc,char *argv[])
{
  char *line;
  int mode;

  if(argc == 2)
    mode = atoi(argv[1]);
  else
    mode = GETLINE_RMEOL | GETLINE_CONCAT | GETLINE_RMCONCAT | GETLINE_COMMENT;

  while((line = jsgetline(stdin,mode))) {
    printf("\"%s\"\n",line);
  }

  return(0);
}
#endif
