/*JS*********************************************************************
*
*    Program : INTPOW
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Faster x^n than 'pow' function.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: intpow.c,v 1.2 1996/04/18 08:43:45 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <math.h>

/*********     DEFINES                                          *********/
#ifndef ABS
#  define ABS(x)    ((x) >= 0  ? (x) : -(x))
#endif

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype double         intpow(double x,int n);

/*JS*********************************************************************
*   Faster algorithm as 'pow' for x^n if n is an integer.
*************************************************************************/

double intpow(double x,int n)

/************************************************************************/
{
  double result;
  int n2 = ABS(n);

  for(result = 1.0 ; n2 ; n2 >>= 1 , x *= x)
    if(n2 & 1) result *= x;

  return(n >= 0 ? result : 1.0 / result);
}

#ifdef TEST
#include <stdio.h>
#include <stdlib.h>

int main(int argc,char *argv[])
{
  double x;
  int i;

  if(argc != 3) {
    printf("Usage: intpow <x> <i>\n\
  Returns x^i, where i is an integer.\n");
    return(5);
  }

  x = strtod(argv[1],NULL);
  i = strtol(argv[2],NULL,10);

  printf("%g^%d = %g\n",x,i,intpow(x,i));

  return(0);
}
#endif
