/*JS*********************************************************************
*
*    Program : FREEEXPR
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Free a expression that has been allocated from routine
*              'CompExpression".
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: freeexpr.c,v 1.1 1995/03/22 13:13:05 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>

#include <jssubs.h>

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype void           FreeExpression(Expression *expr);

/*JS*********************************************************************
*   The memory for the expression is freeed.
*************************************************************************/

void FreeExpression(Expression *expr)

/************************************************************************/
{
  if(expr == NULL) return;

  if(expr->EX_Name)    free(expr->EX_Name);
  if(expr->EX_Consts)  free(expr->EX_Consts);
  if(expr->EX_IpnCode) free(expr->EX_IpnCode);

  free(expr);
}
