/*JS*********************************************************************
*
*    Program : FPLOT
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Routines for plotting data to a file.
*    Part    : Plot one dimensional data.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: fplotvector.c,v 1.6 1995/12/07 12:34:08 joerg Stab joerg $";
#endif

/*********     INCLUDES 					*********/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <fplot.h>

/*********     DEFINES						*********/
#ifndef THISNAME
# define THISNAME    fplotVector
#endif

#ifndef THISTENSOR
# define THISTENSOR  fplotTensor
#endif

#ifndef PRECISION
# define PRECISION double
#endif

#define Prototype extern
/*********     PROTOTYPES					*********/
Prototype int		 fplotVector(FPFile *ffp,int type,const double *xvector,
				      const double *yvector,unsigned long n,
				      long stride,
				      double xMin,double xMax,
				      double fMin,double fMax);

/*JS*********************************************************************
*   Plots one dimensional data with optional values for x axe to the file.
*************************************************************************/

int THISNAME(FPFile *ffp,int type,const PRECISION *xvector,
	     const PRECISION *yvector,
	     unsigned long n,long stride,PRECISION xMin,PRECISION xMax,
	     PRECISION fMin,PRECISION fMax)

/************************************************************************/
{
  PRECISION boundaries[2];

  boundaries[0] = xMin;
  boundaries[1] = xMax;

  return(THISTENSOR(ffp,type,1,xvector ? &xvector : (const PRECISION **)NULL,
		    yvector,&n,&stride,(const PRECISION *)boundaries,
		    fMin,fMax));
}
