/*JS*********************************************************************
*
*    Program : FPLOTTRANS
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Transform fplot data.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: fplottrans.c,v 1.8 1996/10/21 16:04:45 joerg Stab joerg $";
#endif

/*********     INCLUDES 					*********/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jssubs.h>

#include <fplot.h>

#ifndef FPLOT_TRANS_NOEND
/*  START-DEFINITIONS  */
#define FPLOT_TRANS_NOEND    FPLOT_MODE_USER
#define FPLOT_TRANS_APPEND   (FPLOT_MODE_USER << 1)
/*  END-DEFINITIONS  */
#endif

/* ERROR-DEFINITIONS from fplotTransform label _ERR_FPLTTRANS ord 4
   Tranformation routine failed
*/

#define Prototype extern
/*********     PROTOTYPES					*********/
Prototype int		 fplotTransform(char *inName,char *outName,
					int readMode,int nPics,
					int (*doTrans)(int ord,
						       FPPicture *pics[],
						       int npics));

Prototype int		 fplotTransform2(char *inName,char *outName,
					 int readMode,int nPics,
					 int (*doTrans)(int ord,
							FPPicture *pics[],
							int npics));

/*JS*********************************************************************
*   Read a sequence of pictures, call a transform routine and write them
*    back. The transformation routine may signal an error with a negative
*    return value, a positive return value will stop the transformation loop.
*************************************************************************/

int fplotTransform(char *inName,char *outName,int readMode,int nPics,
		   int (*doTrans)(int ord,FPPicture *pics[],int npics))

/************************************************************************/
{
  FPFile *fpIn,*fpOut;
  FPPicture **pics;
  int i,ord;

  pics = NULL;
  fpOut = NULL;

  /*  Open files and get memory  */
  if((fpIn = fplotOpen(inName,FPLOT_READ)) == NULL) goto error;
  if((fpOut = fplotOpen(outName,(readMode & FPLOT_TRANS_APPEND) ?
			FPLOT_APPEND : FPLOT_WRITE)) == NULL) goto error;
  if((pics = (FPPicture **)malloc(nPics * sizeof(*pics))) == NULL) goto error;

  for(ord = 0 ; !feof(fpIn->FF_File) ; ord++) {
    for(i = 0 ; i < nPics ; i++)
      if((pics[i] = fplotRead(fpIn,readMode & (FPLOT_MODE_USER-1))) == NULL) {
	if(feof(fpIn->FF_File)) {
	  /*  Correct end of file reached?  */
	  if(i == 0) goto stopthebus;

	  fprintf(stderr,"WARNING: Last sequence not complete (%d < %d)!\n",
		  i,nPics);

	  while(++i < nPics) pics[i] = NULL;

	  break;
	}

	goto error;
      }

    /*	Transform data if wanted  */
    if(doTrans) {
      int ret;

      if((ret = (*doTrans)(ord,pics,i)) < 0) {
	JSErrNo = _ERR_FPLTTRANS + 0;
	goto error;
      }

      /*  Shall we break?  */
      if(ret != 0) {
	/*  Free memory  */
	for(i = 0 ; i < nPics ; i++) fplotFreepic(pics[i]);

	goto stopthebus;
      }
    }

    /*	Write pictures to output file  */
    for(i = 0 ; i < nPics ; i++) {
      FPData *picData;

      /*  Skip this output picture?  */
      if(pics[i] == NULL) continue;

      /*  Plot title  */
      if(fplotStart((readMode & FPLOT_TRANS_NOEND) ? NULL : fpOut) ||
	 (pics[i]->FP_Title && fplotText(fpOut,pics[i]->FP_Title)))
	goto error;

      /*  Now write data  */
      for(picData = &pics[i]->FP_Content ; picData ;
	  picData = picData->FPD_Next) {
	if(picData->FPD_Data == NULL) continue;

	if(picData->FPD_Flags & FPLOT_FLAGS_SINGLE) {
	  if(fplotSTensor(fpOut,picData->FPD_Type,picData->FPD_NDim,
			  (const float **)picData->FPD_AxeValues,
			  (const float *)picData->FPD_Data,
			  picData->FPD_Dims,NULL,
			  (const float *)picData->FPD_Boundaries,
			  picData->FPD_FMin,picData->FPD_FMax)) goto error;
	} else {
	  if(fplotTensor(fpOut,picData->FPD_Type,picData->FPD_NDim,
			 (const double **)picData->FPD_AxeValues,
			 (const double *)picData->FPD_Data,
			 picData->FPD_Dims,NULL,
			 (const double *)picData->FPD_Boundaries,
			 picData->FPD_FMin,picData->FPD_FMax)) goto error;
	}
      }

      if((pics[i]->FP_Axes && fplotAxes(fpOut,pics[i]->FP_NAxes,
					(const char **)pics[i]->FP_Axes)) ||
	 fplotEnd((readMode & FPLOT_TRANS_NOEND) ? NULL : fpOut)) goto error;
    }

    /*	Free memory  */
    for(i = 0 ; i < nPics ; i++)
      if(pics[i]) fplotFreepic(pics[i]);
  }
stopthebus:

  fplotClose(fpIn);
  fplotClose(fpOut);
  free(pics);

  return(0);
error:
  if(pics) free(pics);
  if(fpOut) fplotClose(fpOut);
  if(fpIn) fplotClose(fpIn);
  return(-1);
}

/*JS*********************************************************************
*   Similar to fplotTransform, but recognizes "-" as synonym for stdin/stdout.
*************************************************************************/

int fplotTransform2(char *inName,char *outName,int readMode,int nPics,
		    int (*doTrans)(int ord,FPPicture *pics[],int npics))

/************************************************************************/
{
  if(strcmp(inName,"-") == 0) inName = NULL;
  if(strcmp(outName,"-") == 0) outName = NULL;

  return(fplotTransform(inName,outName,readMode,nPics,doTrans));
}

#ifdef TEST
/*  Small testroutine: Simply read data and write it back  */
int main(int argc,char *argv[])
{
  int nPics;

  if(argc != 4) {
    printf("Usage: testtransform <infile> <outfile> <npics>\n");
    return(5);
  }

  nPics = atoi(argv[3]);

  if(fplotTransform(argv[1],argv[2],FPLOT_MODE_READ|FPLOT_MODE_NOGETMINMAX,
		    nPics,NULL)) {
    fprintf(stderr,"ERROR in routine fplotTransform!\n");
    return(30);
  }

  return(0);
}
#endif
