/*JS*********************************************************************
*
*    Program : FPLOT
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Routines for plotting data to a file.
*    Part    : Plot text.
*
*      Format of text hunk:
*        hunk header:
*                ulong  hunk_type   (== HUNK_TEXT)
*                ulong  hunk_length (in "sizeof(long)" without hunk header).
*        hunk content:
*            n * bytes  text    Without final '\0', but padded to
*                                multiples of HUNKROUND.
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: fplottext.c,v 1.5 1996/10/21 16:03:59 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include <jssubs.h>

#include <fplot.h>

/*********     DEFINES                                          *********/
/*  We have the choice of either using fseek or the 'vaprintf' function  */
/*#define CONFIG_USE_FSEEK*/

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype int            fplotText(FPFile *fp,const char *format, ...);

/*JS*********************************************************************
*   Like printf, but plots the text in special format to the file.
*************************************************************************/

int fplotText(FPFile *fp,const char *format, ...)

/************************************************************************/
{
  va_list ap;
  OutputHeader oheader;
  int len,pad;
#ifdef CONFIG_USE_FSEEK
  long pos;
#else
  char *buffer;
#endif

  /*  Initialize argument list  */
  va_start(ap,format);

  oheader.OH_Type = HUNK_TEXT;

#ifdef CONFIG_USE_FSEEK
  /*  Write dummy header  */
  oheader.OH_Length = (unsigned long) -1;

  /*  Do all stuff  */
  if((pos = ftell(fp->FF_File)) < 0 ||
     fwrite(&oheader,sizeof(oheader),1,fp->FF_File) != 1 ||
     (len = vfprintf(fp->FF_File,format,ap)) < 0)
    goto error;

  oheader.OH_Length = HUNKLENGTH(len);
  pad = HUNKROUND * oheader.OH_Length - len;

  if((pad > 0 && fwrite("\0\0\0",pad,1,fp->FF_File) != 1) ||
     fseek(fp,pos,SEEK_SET) ||
     fwrite(&oheader,sizeof(oheader),1,fp->FF_File) != 1 ||
     fseek(fp->FF_File,HUNKROUND * oheader.OH_Length,SEEK_CUR))
    goto error;
#else
  /*  Use self-allocated buffer  */
  if((buffer = vaprintf(format,ap)) == NULL) goto error;
  len = strlen(buffer);

  oheader.OH_Length = HUNKLENGTH(len);
  pad = HUNKROUND * oheader.OH_Length - len;

  if(fwrite(&oheader,sizeof(oheader),1,fp->FF_File) != 1 ||
     fwrite(buffer,sizeof(buffer[0]),len,fp->FF_File) != len ||
     (pad > 0 && fwrite("\0\0\0",pad,1,fp->FF_File) != 1))
    goto error;

  free(buffer);
#endif

  va_end(ap);

  return(0);
error:
  va_end(ap);
  return(-1);
}
