/*JS*********************************************************************
*
*    Program : FPLOTSUBS
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Second level subroutines for package fplot.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: fplotsubs.c,v 1.1 1995/11/29 13:14:59 joerg Stab joerg $";
#endif

#define Prototype extern
/*********     PROTOTYPES					*********/
Prototype void           getMinMax(const double *vector,int n,double *pMin,
				   double *pMax);
Prototype void           getMinMaxS(const float *vector,int n,float *pMin,
				    float *pMax);

/*JS*********************************************************************
*   Gets the minimal and maximal value in the vector with n entries.
*************************************************************************/

void getMinMax(const double *vector,int n,double *pMin,double *pMax)

/************************************************************************/
{
  double mi,ma;

  for(mi = ma = vector[0] ; --n > 0 ; ) {
    if(vector[n] > ma)
      ma = vector[n];
    else if(vector[n] < mi)
      mi = vector[n];
  }

  /*  Return the values   */
  *pMin = mi;
  *pMax = ma;

  return;
}

/*JS*********************************************************************
*   Gets the minimal and maximal value in the vector with n entries.
*    Single precision version
*************************************************************************/

void getMinMaxS(const float *vector,int n,float *pMin,float *pMax)

/************************************************************************/
{
  float mi,ma;

  for(mi = ma = vector[0] ; --n > 0 ; ) {
    if(vector[n] > ma)
      ma = vector[n];
    else if(vector[n] < mi)
      mi = vector[n];
  }

  /*  Return the values   */
  *pMin = mi;
  *pMax = ma;

  return;
}
