/*JS*********************************************************************
*
*    Program : FPLOTANALYZE
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Analyze plot data.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: fplotanalyze.c,v 1.5 1997/07/21 21:10:53 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fplot.h>

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype int            fplotAnalyze(char *names[],int nFiles,int readMode[],
				      int nPics,
				      int (*doAnalyze)(int ord,
						       FPPicture *pics[],
						       int nFiles,int nPics));

Prototype int            fplotAnalyze2(char *names[],int nFiles,int readMode[],
				       int nPics,
				       int (*doAnalyze)(int ord,
							FPPicture *pics[],
							int nFiles,int nPics));

/*JS*********************************************************************
*   Opens 'nFiles' files with names from array 'names' in parallel and
*    reads always 'nPics' picture data; 'readMode' specifies how data is
*    read (if read at all). Then calls user supplied routine 'doAnalyze'
*    with 'nFiles * nPics' picture data in array 'pics'. 'ord' says what
*    call this is (starts with 0). The analyzing routine may signal an
*    error with a negative return value.
*************************************************************************/

int fplotAnalyze(char *names[],int nFiles,int readMode[],int nPics,
		 int (*doAnalyze)(int ord,FPPicture *pics[],int nFiles,
				  int nPics))

/************************************************************************/
{
  FPFile **pFp;
  FPPicture **pics;
  int i,ord;

  pics = NULL;

  /*  Get memory   */
  if((pFp = (FPFile **)malloc(nFiles * sizeof(*pFp))) == NULL ||
     (pics = (FPPicture **)malloc(nFiles * nPics * sizeof(*pics))) == NULL)
    goto error;

  /*  Open all files  */
  for(i = 0 ; i < nFiles ; i++)
    if((pFp[i] = fplotOpen(names[i],FPLOT_READ)) == NULL) {
      while(++i < nFiles) pFp[i] = NULL;
      goto error;
    }

  for(ord = 0 ; ; ord++) {
    int j,ret;

    /*  Check for EOF in any file  */
    for(i = 0 ; i < nFiles ; i++) if(feof(pFp[i]->FF_File)) break;
    if(i < nFiles) break;

    /*  Read all data  */
    for(i = 0 ; i < nFiles ; i++) {
      for(j = 0 ; j < nPics ; j++) {
	if((pics[i * nPics + j] = fplotRead(pFp[i],readMode[j])) == NULL &&
	   (readMode[j] & FPLOT_MODE_READ)) {
	  if(feof(pFp[i]->FF_File)) goto stopthebus;

	  goto error;
	}
      }
    }

    /*  Analyze data if wanted  */
    ret = 0;
    if(doAnalyze && (ret = (*doAnalyze)(ord,pics,nFiles,nPics)) < 0)
      goto error;

    /*  Free memory  */
    for(i = 0 ; i < nFiles ; i++)
      for(j = 0 ; j < nPics ; j++)
	fplotFreepic(pics[nPics * i + j]);

    /*  Shall we break?  */
    if(ret != 0) break;
  }
stopthebus:

  /*  Close all files  */
  for(i = 0 ; i < nFiles ; i++) fplotClose(pFp[i]);

  free(pics);

  return(0);
error:
  if(pics) free(pics);

  return(-1);
}

/*JS*********************************************************************
*   Similar to fplotAnalyze, but recognizes "-" as synonyms for stdin/
*    stdout. Does *not* check if this is used multiple times.
*************************************************************************/

int fplotAnalyze2(char *names[],int nFiles,int readMode[],int nPics,
		  int (*doAnalyze)(int ord,FPPicture *pics[],int nFiles,
				   int nPics))

/************************************************************************/
{
  char **n;
  int i;

  /*  Do not destroy original array  */
  if((n = (char **)malloc(nFiles * sizeof(*n))) == NULL) return(-1);

  for(i = 0 ; i < nFiles ; i++)
    n[i] = (strcmp(names[i],"-") == 0) ? NULL : names[i];

  i = fplotAnalyze(n,nFiles,readMode,nPics,doAnalyze);

  free(n);
  return(i);
}

#ifdef TEST
/* ***  Small testroutine: Simply read data :)  *** */
int main(int argc,char *argv[])
{
  int nPics;
static int ReadModes[2] = {
  FPLOT_MODE_READ|FPLOT_MODE_NOGETMINMAX,
  FPLOT_MODE_READ|FPLOT_MODE_NOGETMINMAX
};

  if(argc != 4) {
    printf("Usage: testanalyze <infile1> <infile2> <npics>\n");
    return(5);
  }

  nPics = atoi(argv[3]);

  if(fplotAnalyze(&argv[1],2,readModes,nPics,NULL)) {
    fprintf(stderr,"ERROR in routine fplotAnalyze!\n");
    return(30);
  }

  return(0);
}
#endif
