/*JS*********************************************************************
*
*    Program : FPLOT
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Routines for plotting data to a file.
*    Part    : Routines to start and end output. Every complete output
*              cycle has to be surrounded by 'fplotStart' and 'fplotEnd'.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: fplot.c,v 1.8 1996/10/21 15:52:38 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>

#include <jsconfig.h>
#include <jssubs.h>

#include <fplot.h>

/*********     DEFINES                                          *********/

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype int            fplotStart(FPFile *ffp);
Prototype int            fplotEnd(FPFile *ffp);

/*JS*********************************************************************
*   Locks the file so that current sequence is not disturbed from other
*    processes. If ffp is not given, only CTRL-C is blocked.
*************************************************************************/

int fplotStart(FPFile *ffp)

/************************************************************************/
{
  /*  We don't wanna get disturbed while writing to output  */
  criticalStart();

  if(ffp) {
#ifndef CONFIG_NO_POSIX
    /*  Lock whole file and wait if already locked until  */
    /*   it is unlocked from other process.               */
    if(!(ffp->FF_Flags & FPLOT_FLAG_NOFSEEK) &&
       lockWriteW(ffp->FF_File,0,SEEK_SET,0) < 0)
      goto error;
#endif
  }

  return(0);
error:
  criticalEnd();
  return(-1);
}

/*JS*********************************************************************
*   Writes an end hunk to show the end of current plot and unlocks the
*    whole file. If ffp is not given, only CTRL-C is unblocked.
*************************************************************************/

int fplotEnd(FPFile *ffp)

/************************************************************************/
{
  if(ffp) {
    OutputHeader oheader;

    /*  Set up Header correctly  */
    oheader.OH_Type   = HUNK_END;
    oheader.OH_Length = 0L;

    /*  Write out Header and flush buffers  */
    if(fwrite(&oheader,sizeof(oheader),1,ffp->FF_File) != 1 ||
       fflush(ffp->FF_File))
      goto error;

#ifndef CONFIG_NO_POSIX
    /*  Delete lock  */
    if(!(ffp->FF_Flags & FPLOT_FLAG_NOFSEEK) &&
       unLock(ffp->FF_File,0,SEEK_SET,0) < 0) goto error;
#endif
  }

  /*  Ok, hard job is done, allow user to press CNTRL-C   :(  */
  criticalEnd();

  return(0);
error:
  criticalEnd();
  return(-1);
}
