/* ********************************************** */
/*   Macro for casting C names to FORTRAN names   */
/*    Depends on the machine one works.           */
/*    Usage: FORTRANNAME(name) yields the name    */
/*     one has to use when referencing an object  */
/*     from C which is defined in FORTRAN         */
/* ********************************************** */
#ifndef __FORTNAME_H__ /*  Must not be included more than once	*/
# define __FORTNAME_H__

# if defined(_AIX) || defined(__hpux)
 /*   IBM RS6000 and HP-UX: no change of name required  */
#  define FORTRANNAME(name) name
# else
 /*   Silicon Graphics and rest of the world: We need
  *    a '_' appended to every FORTRAN name to get the
  *    corresponding global name.
  */
#  define FORTRANNAME(name) name##_
# endif
#endif

