/*JS*********************************************************************
*
*    Program : EVALSTRING
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Simple application of CompExpression and EvalExpression:
*              Interpret a string and evaluate it immediately.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: evalstring.c,v 1.1 1996/10/23 16:17:58 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <math.h>

#include <jssubs.h>

/*********     DEFINES                                          *********/

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype double         EvalString(const char *string,const char *varsNames[],
				    const double vars[],
				    const Expression *fcts[],
				    const char **pEnd);

/*JS*********************************************************************
*
*************************************************************************/

double EvalString(const char *string,const char *varNames[],
		  const double vars[],
		  const Expression *fcts[],const char **pEnd)

/************************************************************************/
{
  Expression *expr;
  double x;

  if(pEnd) *pEnd = string; /*  to recognize failure  */

  if((expr = CompExpression(string,varNames,fcts,pEnd)) == NULL)
    return(HUGE_VAL);

  x = EvalExpression(expr,vars,NULL,fcts);

  FreeExpression(expr);

  return(x);
}
