/*JS*********************************************************************
*
*    Program : ERRFKT
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Compute the error function.
*              Taken from Numerical Recipes.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: errfkt.c,v 1.2 1997/08/02 21:44:08 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <math.h>

/*********     DEFINES                                          *********/

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype double         errfkt(double x);

/*JS*********************************************************************
*   Yields 2 / sqrt(PI) Int[0,x] exp(-t^2)dt, which means that
*    errfkt(Infinity) == 1.
*************************************************************************/

double errfkt(double x)

/************************************************************************/
{
  double t,z,ans;

  z = fabs(x);

  t = 1.0 / (1.0 + 0.5 * z);

  ans = t * exp(-z * z -
		1.26551223  + t *
		(1.00002368  + t *
		 (0.37409196  + t *
		  (0.09678418  + t *
		   (-0.18628806 + t *
		    (0.27886807  + t *
		     (-1.13520398 + t *
		      (1.48851587  + t *
		       (-0.82215223 + t * 0.17087277))))))))) - 1.0;

  return(x >= 0.0 ? -ans : ans);
}

#ifdef TEST

#include <stdio.h>
#include <jssubs.h>

#define N 1000
#define X 4.0

int main()
{
  double x,array[N];
  FPFile *fp;
  int i;

  if((fp = fplotOpen("errfkt.out",FPLOT_WRITE)) == NULL) {
    printf("ERROR: Cannot open \"errfkt.out\" -- Break.\n");
    exit(20);
  }

  for(i = 0 ; i < N ; i++) {
    x = -X + i * (2 * X / N);
    array[i] = errfkt(x);
    /*printf("errfkt(%g) = %g\n",x,array[i]);*/
  }

  if(fplotStart(fp) ||
     fplotText(fp,"Error function") ||
     fplotVector(fp,0,NULL,array,N,1,-X,X,1.0,1.0) ||
     fplotEnd(fp)) {
    printf("ERROR: Cannot plot data -- Break.\n");
    exit(20);
  }

  fplotClose(fp);

  /*for(x = -4.0 ; x <= 4.0 ; x += 0.01)
    printf("errfkt(%g) = %g\n",x,errfkt(x));
    */

  return(0);
}
#endif
