/*JS*********************************************************************
*
*    Program : CSTRCOMPILE
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Compile a string with C escape sequences.
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: cstrcompile.c,v 1.3 1997/12/22 14:37:41 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype long           cStrCompile(const char *src,char *dest);

/*JS*********************************************************************
*   Understands C like escape sequences, including escaped quotes. Returns
*    the length of the compiled string in dest ('strlen' may produce wrong
*    results if the string contains '\0'). The line continuation sequence
*    "\\\n" is removed. src and dest may be identical. Unknown escape
*    sequences are kept.
*************************************************************************/

long cStrCompile(const char *src,char *dest)

/************************************************************************/
{
static const char InEsc[]  = "\"\'ntrfvba\\";
static const char OutEsc[] = "\"\'\n\t\r\f\v\b\a\\";
  char *d;

  for(d = dest ; *src ; src++) {
    if(*src == '\\') {
      char *string;

      src++; /*  Skip '\\'  */

      /*  Common escape sequence?  */
      if((string = strchr(InEsc,*src))) {
	*d = OutEsc[string - InEsc];
      } else if(*src == '\n') {
	continue; /*  Skip "\\\n" completely  */
      } else if('0' <= *src && *src <= '7') { /*  Octal number  */
	int i;

	i = 1;
	*d = *src - '0';
	while('0' <= src[1] && src[1] <= '7' && i++ < 3)
	  *d = (*d << 3) | (*++src - '0');
      } else if(*src == 'x') { /*  hexadecimal number  */
	int i;

	*d = 0;
	for(i = 0 ; isxdigit(*(const unsigned char *)src) && i < 2 ; i++) {
	  int s;

	  s = ('a' <= *src && *src <= 'f') ? 'a' :
	    (('A' <= *src && *src <= 'F') ? 'A' : '0');
	  *d = (*d << 4) | (*++src - s);
	}
      } else {
	/*  Unknown escape sequence, keep it in output  */
	*d++ = '\\';
	*d = *src;
      }
    } else
      *d = *src;

    d++;
  }

  return(d - dest);
}

#ifdef TEST
int main(int argc,char *argv[])
{
  char buffer[1000];
  long len,i;

  while(--argc > 0) {
    len = cStrCompile(*++argv,buffer);

    for(i = 0 ; i < len ; i++)
      printf("%#x ",buffer[i]);

    printf("\n");
  }

  return(0);
}
#endif
