/*JS*********************************************************************
*
*    Program : CRITICAL
*    Language: ANSI-C with UNIX SVR4 signal functions
*    Author  : Joerg Schoen
*    Purpose : To surround critical regions of code where a CONTROL-C
*              should not occur. May be nested!
*
*************************************************************************/

#ifndef lint
static const char rcsid[] = "$Id: critical.c,v 1.2 1995/04/04 09:34:18 joerg Stab joerg $";
#endif

/*********     INCLUDES                                         *********/
#include <stdio.h>

#include <jsconfig.h>

#ifndef CONFIG_NO_POSIX
# include <unistd.h>
#endif
#include <signal.h>

#define Prototype extern
/*********     PROTOTYPES                                       *********/
Prototype void           criticalStart(void);
Prototype void           criticalEnd(void);

/*********     GLOBAL / STATIC VARIABLES                        *********/
#ifndef CONFIG_NO_POSIX
static sigset_t OldSet;
static int Counter = 0;

/*JS*********************************************************************
*   Blocks CNTRL-C and kill pid.
*************************************************************************/

void criticalStart(void)

/************************************************************************/
{
  /*  Allow multiple callings  */
  if(Counter++ == 0) {
    sigset_t block;

    /*  Create signal mask with SIGINT and SIGTERM  */
    sigemptyset(&block);
    sigaddset(&block,SIGINT);
    sigaddset(&block,SIGTERM);

    /*  Now block these signals and save old signal mask  */
    sigprocmask(SIG_BLOCK,&block,&OldSet);
  }
}

/*JS*********************************************************************
*   Reset to old signal mask.
*************************************************************************/

void criticalEnd(void)

/************************************************************************/
{
  /*  Prevent Counter become negative  */
  if(Counter <= 0) return;

  /*  Allow multiple callings  */
  if(--Counter == 0) {
    /*  Reset old signal mask  */
    sigprocmask(SIG_SETMASK,&OldSet,NULL);
  }
}
#else
/* ***  Dumb functions when not POSIX compliant  *** */
void criticalStart(void) {  /*  empty  */ }

void criticalEnd(void) {  /*  empty  */  }
#endif

#ifdef TEST
main()
{
  printf("Uncritical region ...\n");
  sleep(15);

  criticalStart();
  printf("Critical region ...\n");
  sleep(15);

  criticalEnd();

  printf("Uncritical region ...\n");
  sleep(15);
}
#endif
