/*JS*********************************************************************
*
*    Program : ANALYZE
*    Language: ANSI-C
*    Author  : Joerg Schoen
*    Purpose : Analyze data in various ways.
*
*************************************************************************/

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>

#include <errno.h>

#include <jssubs.h>

#include <fplot.h>

/*********     DEFINES                                          *********/

/* ----------- FILE: analyze.c            ------------ */
/*  Structure to store one mode  */
struct AnaMode {
  const char *ModeName,*ShortHelp,*LongHelp;
  int NPics;
  int (*ModeFunc)(int argc,char *argv[]);
};

/*  Default name of output file  */
#define OUTPUTFILE   "ana.out"

#define MODE_FPAPPEND       (1<<0)
#define MODE_NOEND          (1<<1)

#define MODE_NOOUTPUT       (1<<2)

#define MODE_USER           (1<<8)

/* ----------- FILE: analyze2.c           ------------ */
/* ***  For routine analyze1  *** */
#define NPICS1   2

#define MODE1_MONOTONICY    MODE_USER

/* ***  For routine transform2  *** */
#define NPICS2   1
#define MAXARCS  801

#define MODE2_SYMMETRIZE    MODE_USER
#define MODE2_LININTERPOL   (MODE_USER<<1)

/* ***  For routine transform3  *** */
#define NPICS3   2

#define MODE3_RENORMALIZE   MODE_USER

/* ----------- FILE: analyze3.c           ------------ */
/* ***  For routine analyze4   *** */
#define NPICS4   2

/* ***  For routine analyze5   *** */
#define NPICS5   1
#define EPSILON  (10.0 * DBL_EPSILON)

/* ***  For routine analyze6   *** */
#define NPICS6   1

/* ***  For routine analyze7   *** */
#define NPICS7   1

#define MODE7_VOLNELEM      MODE_USER

/* ----------- FILE: analyze4.c           ------------ */
/* ***  For routine transform8  *** */
#define NPICS8   1

#define MODE8_FFTMETHOD     MODE_USER

/* ***  For routine transform10  *** */
#define NPICS10   1

#define MODE10_GENAXEDATA   MODE_USER

/* ----------- FILE: analyze5.c           ------------ */
/* ***  For routine transform11  *** */
#define NPICS11   1

#define MODE11_POLYNOMINT   MODE_USER

/* ***  For routine transform12  *** */
#define NPICS12   1

#define MODE12_BACKTRAFO    MODE_USER

/* ***  For routine transform13  *** */
#define NPICS13   2

/* ***  Use routines that will recognize "-"  *** */
#define fplotOpen      fplotOpen2
#define fplotAnalyze   fplotAnalyze2
#define fplotTransform fplotTransform2

/*********     PROTOTYPES                                       *********/
#ifndef Prototype
# define Prototype extern
#endif

/* ***** File: analyze.c             ***** */
Prototype int            changeTitle(FPPicture *pic,char *mess);
Prototype int            Verbose,Mode,NPics,MaxRuns;

/* ***** File: analyze2.c            ***** */
Prototype struct AnaMode Descript1;
Prototype double         rhoExpect(double *a,int nx,int ny,
				   double xMin,double xMax,
				   double yMin,double yMax,
				   double *phiExpect);
Prototype double         LinFactor1;
Prototype struct AnaMode Descript2;
Prototype int            MaxArcs2;
Prototype struct AnaMode Descript3;

/* ***** File: analyze3.c            ***** */
Prototype struct AnaMode Descript4;
Prototype struct AnaMode Descript5;
Prototype double         Epsilon5;
Prototype struct AnaMode Descript6;
Prototype struct AnaMode Descript7;

/* ***** File: analyze4.c            ***** */
Prototype struct AnaMode Descript8;
Prototype struct AnaMode Descript9;
Prototype struct AnaMode Descript10;

/* ***** File: analyze5.c            ***** */
Prototype struct AnaMode Descript11;
Prototype struct AnaMode Descript12;
Prototype struct AnaMode Descript13;
