/*JS*********************************************************************
*
*    Program : TWGTEST1
*    Language: C
*    Author  : Joerg Schoen
*
*    All examples from TW-Graph documentation.
*
*************************************************************************/

/*********     INCLUDES                                         *********/
#include <stdio.h>
#include <math.h>
#include <twgraph.h>

#define MIN(a,b)  ((b) > (a) ? (a) :  (b))

/* **  Prototypes  ** */
int testpointsym(void);
int testlinepatt(void);
int testchartab(void);
int test1(void);
int test2(void);
int test3(void);
int test4(void);
int test5(void);
int test6(void);
int test7(void);
int test8(void);

int main(int argc,char **argv)
{
#ifndef OLD
  /*  Use new capabilities  */
  sgsum(1,1,1,1);
#endif

  spsfn("Times-Bold",0.0);

  testpointsym();
  newpag(1);

  testlinepatt();
  newpag(1);

  testchartab();
  newpag(1);

  test1();
  newpag(1);

  test2();
  newpag(1);

  test3();
  newpag(1);

  test4();
  newpag(1);

  test5();
  newpag(1);

  test6();
  newpag(1);

  test7();
  newpag(1);

  test8();

  /*  Terminate  */
  endplt();

  return(0);
}

/* ***  POINTSYMBOLS  *** */
#define ALEN  16.0
#define YYC   0.43

int testpointsym(void)
{
  float x,y;
  float a,d,xv,yv;
  char cstr[10];
  int i;

  sframe(1,1,1,1);
  scscal(0.8);
  pframe();
  qvsize(&xv,&yv);
  a = 0.5 * (xv - ALEN) / xv;
  d = ALEN / (9.0 * xv);
  y = 0.5;
  stalgn(2,3);

  for(i = 0 ; i < 10 ; i++) {
    smtype(1 + i);
    x = a + i * d;
    pdata(0,-1,&x,&y);
    sprintf(cstr,"%d",1 + i);
    ptext(cstr,x,YYC);
  }
  return(0);
}

/* ***  LINEPATTERNS  *** */
#define X1    0.125
#define X2    0.625
#define XL    0.3
#define DIST  0.05
#define YA    0.7
#define DY    0.1

int testlinepatt(void)
{
  float x[2],y[2];
  char cstr[4];
  int i;

  sframe(1,1,1,1);
  scscal(0.8);
  pframe();
  stalgn(1,3);

  x[0] = X1;
  x[1] = X1 + XL;

  for(i = 1 ; i <= 5 ; i++) {
    y[1] = y[0] = YA - (i - 1) * DY;
    sltype(i);
    sprintf(cstr,"%2d",i);
    ptext(cstr,X1 - DIST,y[0]);
    pdata(4,-2,x,y);
  }

  x[0] = X2;
  x[1] = X2 + XL;

  for(i = 6 ; i <= 10 ; i++) {
    if(i == 10) x[1] = X2 + 0.29;

    y[1] = y[0] = YA - (i - 6) * DY;
    sltype(i);
    sprintf(cstr,"%2d",i);
    ptext(cstr,X2 - DIST,y[0]);
    pdata(4,-2,x,y);
  }
  return(0);
}

/* ***  CHARTABLE  *** */
#define USIZE   42.0
#define VSIZE   29.6
#define XN      0.1
#define GAP     0.052

int testchartab(void)
{
  char *text1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ          ";
  char *text2 = "ABCDEFGHIJKLMNOPQRSTUVWX Y Z        ";
  char *text3 = "0123456789 .,;:?!'\"<>+-*/()=%_#$@  ";
  char *text4 = "0123456789 .,;:?!' \" <>+-*/()=%_#$@";
  char buffer[200];
  int idummy;
  float rdummy,yn,xSize,ySize,scaleW,slwMax;

  yn = 0.8;

  /*  frame box  */
  dpsize(USIZE,VSIZE);
  qpsize(&xSize,&ySize);
  dvsize(xSize,ySize);
  dpbord(0);
  sxscal(0,0.0,0.0);
  syscal(0,0.0,0.0);
  sframe(1,1,1,1);
  pframe();

  /*  heading  */
  qdtype(&idummy,&idummy,&rdummy,&rdummy,&idummy,&rdummy,&slwMax);
  scaleW = MIN(slwMax,3.0);
  slwscl(scaleW);
  ptext("TW GRAPH - Z&2EICHENSATZTABELLE",XN,0.9);

  /*  alphabet  */
  slwscl(1.0);
  scscal(0.8);
  sprintf(buffer,"&&1    &1%-36s",text1);  ptext(buffer,XN,yn);
  sprintf(buffer,"&&2    &2%-36s",text1);  ptext(buffer,XN,yn -       GAP);
  sprintf(buffer,"&&3    &3%-36s",text1);  ptext(buffer,XN,yn - 2.0 * GAP);
  sprintf(buffer,"&&4    &4%-36s",text1);  ptext(buffer,XN,yn - 3.0 * GAP);
  sprintf(buffer,"&&5    &5%-36s",text2);  ptext(buffer,XN,yn - 4.0 * GAP);
  sprintf(buffer,"&&6    &6%-36s",text2);  ptext(buffer,XN,yn - 5.0 * GAP);

  /*  numbers and special characters  */
  yn = 0.42;

  sprintf(buffer,"&&1    &1%-36s",text3);  ptext(buffer,XN,yn            );
  sprintf(buffer,"&&2    &2%-36s",text3);  ptext(buffer,XN,yn -       GAP);
  sprintf(buffer,"&&3    &3%-36s",text3);  ptext(buffer,XN,yn - 2.0 * GAP);
  sprintf(buffer,"&&4    &4%-36s",text3);  ptext(buffer,XN,yn - 3.0 * GAP);
  sprintf(buffer,"&&5    &5%-36s",text4);  ptext(buffer,XN,yn - 4.0 * GAP);
  sprintf(buffer,"&&6    &6%-36s",text4);  ptext(buffer,XN,yn - 5.0 * GAP);

  /*  last line  */
  scscal(0.6);
  ptext("W&2EITERE &1Z&2EICHEN:",XN,0.07);
  scscal(0.8);

  ptext(" &1&A&O&U&2&A&O&U&S&&",999.0,999.0);
  return(0);
}

/* ***  TEST1  *** */
int test1(void)
{
  float x[10] = {
    0.5,   1.5,   3.0,   5.0,   7.0,   9.5
  };
  float y[10] = {
    2.118, 1.187, 0.648, 0.381, 0.248, 0.150
  };

  /*  Plot smoothe curve through data points  */
  pdata(5,6,x,y);

  /*  and mark data points  */
  pdata(0,6,x,y);

  return(0);
}

/* ***  TEST2  *** */
int test2(void)
{
  float x[10] = {
    0.5,   1.5,   3.0,   5.0,   7.0,   9.5
  };
  float y[10] = {
    2.118, 1.187, 0.648, 0.381, 0.248, 0.150
  };

  /*  Different axes  */
  sframe(-13,0,-13,0);

  /*  Logarithmic y scale  */
  syscal(1,0.1,5.0);

  /*  Line type 3  */
  sltype(3);

  /*  Point symbol 5  */
  smtype(5);

  /*  Plot smooth curve and mark points  */
  pdata(5,6,x,y);
  pdata(0,6,x,y);

  /*  Title  */
  ptitle("Example 2",1.1);

  /*  Description of axes  */
  pxtext("Time / secs");
  pytext("Amplitude");

  return(0);
}

/* ***  TEST3  *** */
#define N1 25
#define N2  5

int test3(void)
{
  float x1[50],x2[N2] = {
    1.18, 1.71, 2.37, 3.24, 4.32
  };
  float x3[2];
  float y1[50],y2[N2] = {
    2.19, 7.57e-1, 1.88e-1, 3.13e-2, 9.37e-3
  };
  float y3[2],ye[N2] = {
    9.78e-1, 2.55e-1, 8.94e-2, 1.00e-2, 4.47e-3
  };
  float aa;
  int i;

  /*  Calculate theoretical values  */
  for(aa = 4.82 , i = 1 ; i <= N1 ; i++) {
    x1[i - 1] = 0.2 * (float) i;
    y1[i - 1] = aa / pow(x1[i - 1],(double) 4);
  }

  /*  Set scaling  */
  sxscal(0,1.0,5.0);
  syscal(1,5.0e-3,10.0);

  /*  Plot experimental data  */
  pdate1(2,N2,x2,y2,ye);

  /*  and theoretical curve  */
  sltype(3);
  pdata(5,N1,x1,y1);

  /*  Description  */
#ifdef OLD
  pxtext("&2P&LT&N&1 / G&2E&1V");
  pytext("&2D&4S&2/DX&LT&N (NB)");
#else
  pxtext("p&Lt&N / GeV");
  pytext("d&3s&1/dx&Lt&N (nb)");
#endif
  x2[0] = 0.47;
  y2[0] = 0.80;
  ye[0] = 0.05;
  pdate1(2,-1,x2,y2,ye);
  stalgn(1,3);
#ifdef OLD
  ptext("G&2ALILEI &IET. AL.",0.55,0.8);
#else
  ptext("Galilei &Iet. al.",0.55,0.8);
#endif
  x3[0] = 0.42;
  x3[1] = 0.52;
  y3[0] = 0.65;
  y3[1] = 0.65;
  pdata(-4,-2,x3,y3);
#ifdef OLD
  ptext("A&4RISTOTELHJ",0.55,0.65);
#else
  ptext("A&4ristoteles",0.55,0.65);
#endif

  return(0);
}
#undef N1
#undef N2

/* ***  TEST4  *** */
int test4(void)
{
  float x[5];
  float y[8] = {
    81.2, 23.3, 37.6, 42.9, 66.5, 55.4, 71.9, 75.4
  };

  x[0] = 0.5;
  x[1] = 1.0;

  /*  Scaling  */
  sxscal(0,0.0,9.0);
  sxtlin(1.0,1);
  sxtllm(3,1.0,8.0);
  syscal(0,0.0,100.0);
  sytlin(10.0,1);

  /*  Plot diagram  */
  pdata(-12,8,x,y);

  /*  Paint hatching  */
  pdata(-112,8,x,y);

  /*  Description  */
  ptext("Experimental Spectrum",0.0,1.1);
  pxtext("Channel");
  pytext("Counts per second");

  return(0);
}

/* ***  TEST5  *** */
#define N  5

int test5(void)
{
  float x[N] = {
    1.0, 2.0, 3.0, 4.0, 5.0
  };
  float y[N] = {
    0.251, 0.416, 0.623, 0.535, 0.872
  };
  float yErr[N] = {
    0.05, 0.05, 0.07, 0.075, 0.11
  };
  float ys[N];

  /*  Scaling  */
  sxscal(0,0.0,6.0);
  sframe(13,1,13,1);

  /*  Draw data  */
  smtype(3);
  pdate1(-2,N,x,y,yErr);

  /*  Draw smooth interpolation curve  */
  sltype(4);
  pdata(5,N,x,y);

  /*  Draw average curve  */
  sltype(3);
  usmote(0.5,N,x,y,yErr,ys);
  pdata(5,N,x,ys);

  /*  Draw straight line  */
  sltype(1);
  usmote(1.0,N,x,y,yErr,ys);
  pdata(4,N,x,ys);

  /*  Draw legend  */
  stalgn(1,3);
  x[0] = 0.08;
  x[1] = 0.18;
  y[0] = 0.9;
  y[1] = y[0];

  sltype(4);
  pdata(4,-2,x,y);
  ptext("Interpolation",0.2,y[0]);

  y[0] = 0.82;
  y[1] = y[0];
  sltype(3);
  pdata(4,-2,x,y);
  ptext("S = 0.50",0.2,y[0]);

  y[0] = 0.74;
  y[1] = y[0];
  sltype(1);
  pdata(4,-2,x,y);
  ptext("S = 1.00",0.2,y[0]);

  return(0);
}
#undef N

/* ***  TEST6  *** */
#define N     70
#define NLEV  6

int test6(void)
{
  float z[N][N];
  float zLev[NLEV] = {
    0.5, 1.0, 2.0, 3.0, 4.0, 5.0
  };
  float x[1],y[1];
  float px1,px2,py1,py2,x1,x2,y1,y2,dx,dy;
  int i,j;

  px1 = -0.5;
  px2 =  0.5;

  py1 = 0.0;
  py2 = 0.0;
  x1 = -1.0;
  x2 =  1.0;
  y1 = -1.0;
  y2 =  1.0;

  dx = (x2 - x1) / (N - 1);
  dy = (y2 - y1) / (N - 1);

  /*  Calculate z values  */
  for(j = 0 ; j < N ; j++) {
    float xx,yy;

    yy = y1 + j * dy;
    for(i = 0 ; i < N ; i++) {
      xx = x1 + i * dx;
      z[j][i] = 1.0 / sqrt((yy - py1) * (yy - py1) + (xx - px1) * (xx - px1))
        -1.0 / sqrt((yy - py2) * (yy - py2) + (xx - px2) * (xx - px2));
    }
  }

  dvsize(15.0,15.0);
  sxscal(0,x1,x2);
  syscal(0,y1,y2);

  /*  Draw positive contour lines, line type 2  */
  sltype(2);
  pdatac(-N,x,-N,y,N,z[0],NLEV,zLev);

  /*  Draw negative contour lines, line type 4  */
  for(i = 0 ; i < NLEV ; i++)
    zLev[i] = -zLev[i];

  sltype(4);
  pdatac(-N,x,-N,y,N,z[0],NLEV,zLev);

  /*  Draw contour line 0.0, line type 1  */
  zLev[0] = 0.0;
  sltype(1);
  pdatac(-N,x,-N,y,N,z[0],1,zLev);

  /*  Legend  */
  ptext("&Aquipotentiallinien",0.0,1.05);
  stalgn(2,3);
  ptext("+",0.25,0.5);
  ptext("-",0.75,0.5);

  return(0);
}
#undef N
#undef NLEV

/* ***  TEST7  *** */
#define N    41

int test7(void)
{
  float xp[4],yp[4],x[N],y[N],z[N][N];
  int i,j,np,ipat;

  /*  Draw function z = sin(sqrt(x*x + y*y))  */
  np = 4;
  xp[0]= 0.0;
  yp[0]= 0.0;
  xp[1]= 29.7;
  yp[1]= 0.0;
  xp[2]= 29.7;
  yp[2]= 21.0;
  xp[3]= 0.0;
  yp[3]= 21.0;
  ipat = -7;

  /*  Calculate functions values  */
  for(j = 0 ; j < N ; j++) {
    y[j] = 0.25 * (j - 20);
    for(i = 0 ; i < N ; i++) {
      x[i] = 0.25 * (i - 20);
      z[j][i] = sin(sqrt(x[i] * x[i] + y[j] * y[j]));
    }
  }

  /*  Draw lower side of function surface  */
  dpsize(29.7,21.0);
  scolor(2);
  shdlr3(2);
  pdata3(13,N,x,N,y,N,z[0]);
  flarea(np,xp,yp,ipat);

  /*  Draw upper side of function surface  */
  scolor(5);
  shdlr3(1);
  pdata3(13,N,x,N,y,N,z[0]);

  /*  Draw legend  */
  scolor(1);
#ifdef OLD
  ptitle("&2SIN X*X+X*X&B&B&B&B&B&B&B&B&6IWWWWWWW",1.08);
#else
  ptitle("sin(sqrt(x*x+y*y))",1.08);
#endif
  stalgn(2,3);
  scscal(2.0);
  stdir3(1.0,0.0,0.0,0.0,1.0,0.0);
  ptext3("x-axis",0.5,-0.2,0.0);
  stdir3(0.0,-1.0,0.0,1.0,0.0,0.0);
  ptext3("y-axis",-0.2,0.5,0.0);

  return(0);
}
#undef N

/* ***  TEST8  *** */
#define N     50
#define NLEV  6

int test8(void)
{
  float z[N][N];
  float zLev[NLEV] = {
    0.5, 1.0, 2.0, 3.0, 4.0, 5.0
  };
  float x[1],y[1];
  float px1,px2,py1,py2,x1,x2,y1,y2,dx,dy;
  int i,j;

  px1 = -0.5;
  px2 =  0.5;

  py1 = 0.0;
  py2 = 0.0;
  x1 = -1.0;
  x2 =  1.0;
  y1 = -1.0;
  y2 =  1.0;

  dx = (x2 - x1) / (N - 1);
  dy = (y2 - y1) / (N - 1);

  /*  Calculate z values  */
  for(j = 0 ; j < N ; j++) {
    float xx,yy;

    yy = y1 + j * dy;
    for(i = 0 ; i < N ; i++) {
      xx = x1 + i * dx;
      z[j][i] = 1.0 / sqrt((yy - py1) * (yy - py1) + (xx - px1) * (xx - px1))
        -1.0 / sqrt((yy - py2) * (yy - py2) + (xx - px2) * (xx - px2));
    }
  }

  dvsize(15.0,15.0);
  sxscal(0,x1,x2);
  syscal(0,y1,y2);

  /*  Draw contour line 0.0, line type 1  */
  zLev[0] = 0.0;
  sltype(1);
  pdata3c(13,-N,x,-N,y,N,z[0],1,zLev,100.0);

  /*  Draw positive contour lines, line type 2  */
  zLev[0] = 0.5;
  sltype(2);
  pdata3c(0,-N,x,-N,y,N,z[0],NLEV,zLev,100.0);

  /*  Draw negative contour lines, line type 4  */
  for(i = 0 ; i < NLEV ; i++)
    zLev[i] = -zLev[i];

  sltype(4);
  pdata3c(0,-N,x,-N,y,N,z[0],NLEV,zLev,100.0);

  /*  Legend  */
  ptext("&Aquipotentiallinien",0.0,1.05);
  stalgn(2,3);

/*  ptext("+",0.25,0.5);*/
/*  ptext("-",0.75,0.5);*/

  return(0);
}
#undef N
#undef NLEV
